/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.tracecompass.internal.ctf.core.utils.SparseList;
import org.junit.Assert;
import org.junit.Test;

public class SparseListTest {
    protected List<String> createList() {
        return new SparseList();
    }

    protected List<String> createList(List<String> reference) {
        return new SparseList(reference);
    }

    @Test
    public void testSimple() {
        List<String> test = this.createList();
        test.add("Pomme");
        int i = 0;
        while (i < 99999) {
            test.add(null);
            ++i;
        }
        test.add("Peche");
        i = 0;
        while (i < 99999) {
            test.add(null);
            ++i;
        }
        test.add("Poire");
        i = 0;
        while (i < 99998) {
            test.add(null);
            ++i;
        }
        test.add("Banane");
        Assert.assertEquals((long)300000L, (long)test.size());
    }

    @Test
    public void testEquality() {
        List<String> test = this.createList();
        test.add("Pomme");
        test.add("Peche");
        test.add("Poire");
        test.add("Banane");
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        List<String> badReference = Arrays.asList("Apple", "Peach", "Pear", "Banana");
        List<String> outOfOrderReference = Arrays.asList("Pomme", "Peche", "Banane", "Poire");
        Assert.assertEquals(reference, test);
        Assert.assertNotEquals(badReference, test);
        Assert.assertNotEquals(outOfOrderReference, test);
        Assert.assertTrue((boolean)test.add(null));
        Assert.assertNotEquals(reference, test);
    }

    @Test
    public void testCopyConstructor() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        List<String> test = this.createList(reference);
        Assert.assertEquals(reference, test);
    }

    @Test
    public void testCopyConstructorWithNull() {
        ArrayList<String> reference = new ArrayList<String>();
        reference.add(null);
        List<String> test = this.createList(reference);
        Assert.assertEquals(reference, test);
    }

    @Test
    public void testHashCollision() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        SparseList test = new SparseList();
        test.ensureSize(1000000);
        test.set(242899, (Object)reference.get(0));
        test.set(583202, (Object)reference.get(1));
        test.set(703005, (Object)reference.get(2));
        test.set(962783, (Object)reference.get(3));
        Assert.assertArrayEquals((Object[])reference.toArray(), (Object[])test.toArray());
        Assert.assertArrayEquals((Object[])reference.toArray(new String[4]), (Object[])test.toArray((Object[])new String[4]));
    }

    @Test
    public void testRecursiveCopyConstructor() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        List<String> test = this.createList(this.createList(this.createList(this.createList(reference))));
        Assert.assertEquals(reference, test);
    }

    @Test
    public void testCopyConstructorWithNulls() {
        List<String> reference = Arrays.asList("Pomme", null, "Peche", null, "Poire", null, "Banane", null);
        List<String> test = this.createList(reference);
        Assert.assertEquals(reference, test);
    }

    @Test
    public void testStreams() {
        List<String> reference = Arrays.asList("Pomme", null, "Peche", null, "Poire", null, "Banane", null);
        Optional first = reference.stream().findFirst();
        Assert.assertTrue((boolean)first.isPresent());
        Assert.assertEquals((Object)"Pomme", first.get());
        Optional<String> firstNonNull = reference.stream().filter(Objects::nonNull).findFirst();
        Assert.assertTrue((boolean)firstNonNull.isPresent());
        Assert.assertEquals((Object)"Pomme", (Object)firstNonNull.get());
        Assert.assertEquals((long)4L, (long)reference.stream().filter(Objects::isNull).count());
        Assert.assertEquals(Arrays.asList("Pomme", null, "Peche", "Poire", "Banane"), reference.stream().distinct().collect(Collectors.toList()));
    }

    @Test
    public void testClear() {
        List<String> test = this.createList();
        List<String> reference = Arrays.asList("Pomme", "Peche", null, "Poire", "Banane");
        Assert.assertTrue((boolean)test.isEmpty());
        test.addAll(reference);
        Assert.assertEquals(reference, test);
        test.clear();
        Assert.assertTrue((boolean)test.isEmpty());
    }

    @Test
    public void testIsEmpty() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        List<String> test = this.createList();
        Assert.assertTrue((boolean)test.isEmpty());
        test.addAll(test);
        Assert.assertTrue((boolean)test.isEmpty());
        test.addAll(reference);
        Assert.assertFalse((boolean)test.isEmpty());
        test = this.createList();
        Assert.assertTrue((boolean)test.isEmpty());
        test.add(null);
        Assert.assertFalse((boolean)test.isEmpty());
    }

    @Test
    public void testContains() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        List<String> test = this.createList(reference);
        Assert.assertTrue((boolean)test.contains("Pomme"));
        Assert.assertFalse((boolean)test.contains(null));
        Assert.assertTrue((boolean)test.containsAll(Arrays.asList("Peche", "Pomme")));
        Assert.assertFalse((boolean)test.containsAll(Arrays.asList("Pomme", null, "Peche", null)));
        test.add(null);
        Assert.assertTrue((boolean)test.contains("Pomme"));
        Assert.assertTrue((boolean)test.contains(null));
        Assert.assertTrue((boolean)test.containsAll(Arrays.asList("Peche", "Pomme")));
        Assert.assertTrue((boolean)test.containsAll(Arrays.asList("Pomme", null, "Peche", null)));
    }

    @Test
    public void testIndexOf() {
        List<String> test = this.createList();
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("mushroom");
        test.add("mushroom");
        Assert.assertEquals((long)0L, (long)test.indexOf("badger"));
        Assert.assertEquals((long)-1L, (long)test.indexOf("a snake"));
        Assert.assertEquals((long)-1L, (long)test.indexOf(null));
        Assert.assertEquals((long)-1L, (long)test.lastIndexOf(null));
        Assert.assertEquals((long)11L, (long)test.lastIndexOf("badger"));
        Assert.assertTrue((boolean)test.contains("badger"));
        Assert.assertTrue((boolean)test.containsAll(Collections.singleton("badger")));
        Assert.assertTrue((boolean)test.containsAll(Arrays.asList("badger", "mushroom")));
    }

    @Test
    public void testStream() {
        List<String> test = this.createList();
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("badger");
        test.add("mushroom");
        test.add("mushroom");
        Assert.assertEquals((long)12L, (long)test.parallelStream().filter("badger"::equals).count());
    }

    @Test
    public void testToArray() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        List<String> test = this.createList(reference);
        Assert.assertArrayEquals((Object[])reference.toArray(), (Object[])test.toArray());
        Assert.assertArrayEquals((Object[])reference.toArray(new String[4]), (Object[])test.toArray(new String[4]));
        List<String> referenceWithNulls = Arrays.asList("Pomme", "Peche", "Poire", null, "Banane");
        test = this.createList(referenceWithNulls);
        Assert.assertArrayEquals((Object[])reference.toArray(), (Object[])test.toArray());
        Assert.assertArrayEquals((Object[])reference.toArray(new String[4]), (Object[])test.toArray(new String[4]));
        Assert.assertArrayEquals((Object[])reference.toArray(new String[4]), (Object[])test.toArray(new String[1]));
        Assert.assertArrayEquals((Object[])reference.toArray(new String[5]), (Object[])test.toArray(new String[5]));
        try {
            Assert.assertArrayEquals((Object[])reference.toArray(new String[4]), (Object[])test.toArray(new Long[4]));
            Assert.fail((String)"Should not get here");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", null, "Banane");
        List<String> test = this.createList(reference);
        Assert.assertEquals((Object)"[0:Pomme, 1:Peche, 2:Poire, 4:Banane]", (Object)test.toString());
    }

    @Test
    public void testSet() {
        List<String> reference = Arrays.asList("Pomme", "Peche", "Poire", "Banane");
        List<String> test = this.createList(reference);
        Assert.assertEquals(reference, test);
        test.set(0, "pomme");
        Assert.assertNotEquals(reference, test);
        try {
            test.set(-1, "pomme");
            Assert.fail((String)"Should not get here");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            test.set(5, "pomme");
            Assert.fail((String)"Should not get here");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testListIterator() {
        SparseListTest.testListIterator(this.createList(Arrays.asList("Hola", "yo", "quiero", "un", "UNSUPPORTEDOPERATIONEXCEPTION!")));
    }

    @Test
    public void testListIteratorOutOfOrder() {
        SparseList list = new SparseList();
        list.ensureSize(5);
        list.set(4, (Object)"UNSUPPORTEDOPERATIONEXCEPTION!");
        list.set(2, (Object)"quiero");
        list.set(1, (Object)"yo");
        list.set(0, (Object)"Hola");
        list.set(3, (Object)"un");
        SparseListTest.testListIterator((List<String>)list);
    }

    private static void testListIterator(List<String> test) {
        ListIterator<String> iterator = test.listIterator(0);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasPrevious());
        try {
            iterator.previous();
            Assert.fail((String)"Should not get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"Hola", (Object)iterator.next());
        Assert.assertEquals((Object)"yo", (Object)iterator.next());
        Assert.assertEquals((Object)"yo", (Object)iterator.previous());
        Assert.assertEquals((Object)"Hola", (Object)iterator.previous());
        try {
            iterator.previous();
            Assert.fail((String)"Should not get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"Hola", (Object)iterator.next());
        Assert.assertEquals((Object)"yo", (Object)iterator.next());
        Assert.assertEquals((Object)"quiero", (Object)iterator.next());
        Assert.assertEquals((Object)"un", (Object)iterator.next());
        Assert.assertEquals((Object)"UNSUPPORTEDOPERATIONEXCEPTION!", (Object)iterator.next());
        try {
            iterator.next();
            Assert.fail((String)"Should not get here");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"UNSUPPORTEDOPERATIONEXCEPTION!", (Object)iterator.previous());
        Assert.assertEquals((long)3L, (long)iterator.previousIndex());
        Assert.assertEquals((long)4L, (long)iterator.nextIndex());
        try {
            iterator.remove();
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            iterator.set("hej");
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            iterator.add("hi");
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testListIteratorWithNull() {
        List<String> list = this.createList(Arrays.asList("Hello", null, "world"));
        ListIterator<String> iterator = list.listIterator();
        Assert.assertEquals((Object)"Hello", (Object)iterator.next());
        Assert.assertEquals(null, (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.previous());
        Assert.assertEquals(null, (Object)iterator.previous());
        Assert.assertEquals((Object)"Hello", (Object)iterator.previous());
        iterator = list.listIterator(0);
        Assert.assertEquals((Object)"Hello", (Object)iterator.next());
        Assert.assertEquals(null, (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.previous());
        Assert.assertEquals(null, (Object)iterator.previous());
        Assert.assertEquals((Object)"Hello", (Object)iterator.previous());
        iterator = list.listIterator(1);
        Assert.assertEquals((Object)"Hello", (Object)iterator.previous());
        Assert.assertEquals((Object)"Hello", (Object)iterator.next());
        Assert.assertEquals(null, (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.previous());
        Assert.assertEquals(null, (Object)iterator.previous());
        Assert.assertEquals((Object)"Hello", (Object)iterator.previous());
        iterator = list.listIterator(2);
        Assert.assertEquals(null, (Object)iterator.previous());
        Assert.assertEquals((Object)"Hello", (Object)iterator.previous());
        Assert.assertEquals((Object)"Hello", (Object)iterator.next());
        Assert.assertEquals(null, (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.next());
        Assert.assertEquals((Object)"world", (Object)iterator.previous());
        Assert.assertEquals(null, (Object)iterator.previous());
        Assert.assertEquals((Object)"Hello", (Object)iterator.previous());
    }

    @Test
    public void testUnorderedSet() {
        String value = "badger";
        List<String> test = this.createList();
        ((SparseList)test).ensureSize(5);
        test.set(4, value);
        test.set(2, value);
        Assert.assertEquals((long)2L, (long)test.indexOf(value));
        Assert.assertEquals((long)4L, (long)test.lastIndexOf(value));
        Assert.assertEquals((long)0L, (long)test.indexOf(null));
        Assert.assertEquals((long)3L, (long)test.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)test.indexOf("mushroom"));
        Assert.assertEquals((long)-1L, (long)test.lastIndexOf("mushroom"));
        Assert.assertNull((Object)test.get(0));
        Assert.assertNull((Object)test.get(1));
        Assert.assertEquals((Object)value, (Object)test.get(2));
        Assert.assertNull((Object)test.get(3));
        Assert.assertEquals((Object)value, (Object)test.get(4));
        test.set(0, value);
        Assert.assertEquals((long)1L, (long)test.indexOf(null));
    }

    @Test
    public void testUnsupporteds() {
        List<String> test = this.createList();
        try {
            test.addAll(0, Collections.emptyList());
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            test.add(0, null);
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            test.remove(0);
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            test.subList(0, 0);
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            test.remove("que?");
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            test.removeAll(Collections.singletonList("que?"));
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            test.retainAll(Arrays.asList("que", "pasa?"));
            Assert.fail((String)"Should not get here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            test.get(-1);
            Assert.fail((String)"Should not get here");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            test.get(test.size());
            Assert.fail((String)"Should not get here");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

