/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend.historytree;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.stubs.backend.HistoryTreeClassicStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HistoryTreeTest {
    private static final int BLOCK_SIZE = 4096;
    private static final HTInterval NULL_INTERVAL = new HTInterval(10L, 20L, 1, (Object)TmfStateValue.nullValue());
    private static final String TEST_STRING = "abcdefghifklmnopqrstuvw";
    private static final TmfStateValue STRING_VALUE = TmfStateValue.newValueString((String)"abcdefghifklmnopqrstuvw");
    private static final HTInterval STRING_INTERVAL = new HTInterval(10L, 20L, 1, (Object)STRING_VALUE);
    private static final TmfStateValue LONG_VALUE = TmfStateValue.newValueLong((long)10L);
    private static final HTInterval LONG_INTERVAL = new HTInterval(10L, 20L, 1, (Object)LONG_VALUE);
    private static final TmfStateValue INT_VALUE = TmfStateValue.newValueInt((int)1);
    private static final HTInterval INT_INTERVAL = new HTInterval(10L, 20L, 1, (Object)INT_VALUE);
    private @Nullable File fTempFile;

    @Before
    public void setupTest() {
        try {
            this.fTempFile = File.createTempFile("tmpStateSystem", null);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanup() {
        if (this.fTempFile != null) {
            this.fTempFile.delete();
        }
    }

    private HistoryTreeClassicStub setupSmallTree(int maxChildren) {
        HistoryTreeClassicStub ht = null;
        try {
            File newFile = this.fTempFile;
            Assert.assertNotNull((Object)newFile);
            HTConfig config = new HTConfig(newFile, 4096, maxChildren, 1, 1L);
            ht = new HistoryTreeClassicStub(config);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull(ht);
        return ht;
    }

    private HistoryTreeClassicStub setupSmallTree() {
        return this.setupSmallTree(3);
    }

    private static long addValues(IHistoryTree ht, TmfStateValue value, int nbValues, long start) {
        int i = 0;
        while (i < nbValues) {
            ht.insertInterval(new HTInterval(start + (long)i, start + (long)i + 1L, 1, (Object)value));
            ++i;
        }
        return start + (long)nbValues;
    }

    private static long fillValues(IHistoryTree ht, TmfStateValue value, HTNode node, long start) {
        HTInterval interval;
        int i = 0;
        while ((interval = new HTInterval(start + (long)i, start + (long)i + 1L, 1, (Object)value)).getSizeOnDisk(node.getNodeStart()) <= node.getNodeFreeSpace()) {
            ht.insertInterval(interval);
            ++i;
        }
        return start + (long)i;
    }

    private static long fillNextLeafNode(HistoryTreeClassicStub ht, long leafNodeStart) {
        int prevCount = ht.getNodeCount();
        int prevDepth = ht.getDepth();
        HTNode node = ht.getLatestLeaf();
        long ret = HistoryTreeTest.fillValues((IHistoryTree)ht, STRING_VALUE, node, leafNodeStart);
        Assert.assertEquals((long)prevCount, (long)ht.getNodeCount());
        Assert.assertEquals((long)prevDepth, (long)ht.getDepth());
        return ret;
    }

    @Test
    public void testSequentialFill() {
        HistoryTreeClassicStub ht = this.setupSmallTree();
        HTNode node = ht.getLatestLeaf();
        Assert.assertEquals((long)0L, (long)node.getNodeUsagePercent());
        int nodeFreeSpace = node.getNodeFreeSpace();
        int intervalSize = NULL_INTERVAL.getSizeOnDisk();
        int nbIntervals = nodeFreeSpace / 10 / intervalSize;
        long start = HistoryTreeTest.addValues((IHistoryTree)ht, TmfStateValue.nullValue(), nbIntervals, 1L);
        Assert.assertEquals((long)(nodeFreeSpace - nbIntervals * intervalSize), (long)node.getNodeFreeSpace());
        nodeFreeSpace = node.getNodeFreeSpace();
        intervalSize = INT_INTERVAL.getSizeOnDisk();
        nbIntervals = nodeFreeSpace / 10 / intervalSize;
        start = HistoryTreeTest.addValues((IHistoryTree)ht, INT_VALUE, nbIntervals, start);
        Assert.assertEquals((long)(nodeFreeSpace - nbIntervals * intervalSize), (long)node.getNodeFreeSpace());
        nodeFreeSpace = node.getNodeFreeSpace();
        intervalSize = LONG_INTERVAL.getSizeOnDisk();
        nbIntervals = nodeFreeSpace / 10 / intervalSize;
        start = HistoryTreeTest.addValues((IHistoryTree)ht, LONG_VALUE, nbIntervals, start);
        Assert.assertEquals((long)(nodeFreeSpace - nbIntervals * intervalSize), (long)node.getNodeFreeSpace());
        nodeFreeSpace = node.getNodeFreeSpace();
        intervalSize = STRING_INTERVAL.getSizeOnDisk();
        nbIntervals = nodeFreeSpace / 10 / intervalSize;
        start = HistoryTreeTest.addValues((IHistoryTree)ht, STRING_VALUE, nbIntervals, start);
        Assert.assertEquals((long)(nodeFreeSpace - nbIntervals * intervalSize), (long)node.getNodeFreeSpace());
    }

    @Test
    public void testDepth() {
        HistoryTreeClassicStub ht = this.setupSmallTree();
        HTNode node = ht.getLatestLeaf();
        long start = HistoryTreeTest.fillValues((IHistoryTree)ht, STRING_VALUE, node, 1L);
        Assert.assertEquals((long)1L, (long)ht.getNodeCount());
        Assert.assertEquals((long)1L, (long)ht.getDepth());
        start = HistoryTreeTest.addValues((IHistoryTree)ht, STRING_VALUE, 1, start);
        Assert.assertEquals((long)3L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        node = ht.getLatestLeaf();
        start = HistoryTreeTest.fillValues((IHistoryTree)ht, STRING_VALUE, node, start);
        start = HistoryTreeTest.addValues((IHistoryTree)ht, STRING_VALUE, 1, start);
        Assert.assertEquals((long)4L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        node = ht.getLatestLeaf();
        start = HistoryTreeTest.fillValues((IHistoryTree)ht, STRING_VALUE, node, start);
        start = HistoryTreeTest.addValues((IHistoryTree)ht, STRING_VALUE, 1, start);
        Assert.assertEquals((long)7L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
    }

    @Test
    public void testNodeSequenceNumbers() throws ClosedChannelException {
        long start = 1L;
        HistoryTreeClassicStub ht = this.setupSmallTree(2);
        start = HistoryTreeTest.fillNextLeafNode(ht, start);
        List<HTNode> branch = ht.getLatestBranch();
        Assert.assertEquals((long)1L, (long)branch.size());
        Assert.assertEquals((long)0L, (long)branch.get(0).getSequenceNumber());
        Assert.assertEquals((long)-1L, (long)branch.get(0).getParentSequenceNumber());
        start = HistoryTreeTest.addValues((IHistoryTree)ht, STRING_VALUE, 1, start);
        start = HistoryTreeTest.fillNextLeafNode(ht, start);
        Assert.assertEquals((long)3L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        HTNode node = ht.readNode(0);
        Assert.assertEquals((long)0L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)1L, (long)node.getParentSequenceNumber());
        branch = ht.getLatestBranch();
        Assert.assertEquals((long)2L, (long)branch.size());
        Assert.assertEquals((long)1L, (long)branch.get(0).getSequenceNumber());
        Assert.assertEquals((long)-1L, (long)branch.get(0).getParentSequenceNumber());
        Assert.assertEquals((long)2L, (long)branch.get(1).getSequenceNumber());
        Assert.assertEquals((long)1L, (long)branch.get(1).getParentSequenceNumber());
        start = HistoryTreeTest.addValues((IHistoryTree)ht, STRING_VALUE, 1, start);
        start = HistoryTreeTest.fillNextLeafNode(ht, start);
        Assert.assertEquals((long)6L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
        node = ht.readNode(0);
        Assert.assertEquals((long)0L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)1L, (long)node.getParentSequenceNumber());
        node = ht.readNode(1);
        Assert.assertEquals((long)1L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)3L, (long)node.getParentSequenceNumber());
        node = ht.readNode(2);
        Assert.assertEquals((long)2L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)1L, (long)node.getParentSequenceNumber());
        branch = ht.getLatestBranch();
        Assert.assertEquals((long)3L, (long)branch.size());
        Assert.assertEquals((long)3L, (long)branch.get(0).getSequenceNumber());
        Assert.assertEquals((long)-1L, (long)branch.get(0).getParentSequenceNumber());
        Assert.assertEquals((long)4L, (long)branch.get(1).getSequenceNumber());
        Assert.assertEquals((long)3L, (long)branch.get(1).getParentSequenceNumber());
        Assert.assertEquals((long)5L, (long)branch.get(2).getSequenceNumber());
        Assert.assertEquals((long)4L, (long)branch.get(2).getParentSequenceNumber());
    }
}

