/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import com.google.common.collect.Multimap;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class TimeEvent
implements ITimeEvent {
    protected ITimeGraphEntry fEntry;
    private final ITimeElement fModel;
    protected long fTime;
    protected long fDuration;
    private static final int NOVALUE = Integer.MIN_VALUE;

    public TimeEvent(ITimeGraphEntry entry, long time, long duration) {
        this(entry, time, duration, Integer.MIN_VALUE);
    }

    public TimeEvent(ITimeGraphEntry entry, long time, long duration, int value) {
        this(entry, (ITimeElement)new TimeGraphState(time, duration, value));
    }

    public TimeEvent(ITimeGraphEntry entry, long time, long duration, int value, int activeProperties) {
        this(entry, (ITimeElement)new TimeGraphState(time, duration, value));
        this.fModel.setActiveProperties(activeProperties);
    }

    public TimeEvent(ITimeGraphEntry entry, ITimeElement stateModel) {
        this.fEntry = entry;
        this.fTime = stateModel.getStartTime();
        this.fDuration = stateModel.getDuration();
        this.fModel = stateModel;
    }

    public int getValue() {
        return this.fModel.getValue();
    }

    public boolean hasValue() {
        return this.getValue() != Integer.MIN_VALUE;
    }

    @Override
    public ITimeGraphEntry getEntry() {
        return this.fEntry;
    }

    @Override
    public long getTime() {
        return this.fModel.getStartTime();
    }

    @Override
    public long getDuration() {
        return this.fModel.getDuration();
    }

    public ITimeElement getModel() {
        return this.fModel;
    }

    @Override
    public ITimeEvent splitBefore(long splitTime) {
        return splitTime > this.fTime ? new TimeEvent(this.fEntry, this.fTime, Math.min(this.fDuration, splitTime - this.fTime), this.getValue(), this.getActiveProperties()) : null;
    }

    @Override
    public ITimeEvent splitAfter(long splitTime) {
        return splitTime < this.fTime + this.fDuration ? new TimeEvent(this.fEntry, Math.max(this.fTime, splitTime), this.fDuration - Math.max(0L, splitTime - this.fTime), this.getValue(), this.getActiveProperties()) : null;
    }

    public int hashCode() {
        return Objects.hash(this.fEntry, this.fTime, this.fDuration, this.getValue(), this.getActiveProperties(), this.fModel.getStyle());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeEvent other = (TimeEvent)obj;
        return Objects.equals(this.fEntry, other.getEntry()) && Objects.equals(this.fTime, other.getTime()) && Objects.equals(this.fDuration, other.getDuration()) && Objects.equals(this.getValue(), other.getValue()) && Objects.equals(this.getActiveProperties(), other.getActiveProperties()) && Objects.equals(this.fModel.getStyle(), other.getModel().getStyle());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " start=" + this.fTime + " end=" + (this.fTime + this.fDuration) + " duration=" + this.fDuration + (String)(this.hasValue() ? " value=" + this.getValue() : "");
    }

    public int getActiveProperties() {
        return this.fModel.getActiveProperties();
    }

    public void setActiveProperties(int activeProperties) {
        this.fModel.setActiveProperties(activeProperties);
    }

    @Override
    public @NonNull Multimap<@NonNull String, @NonNull Object> getMetadata() {
        return this.fModel.getMetadata();
    }
}

