/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.resource.MoveResourcesDescriptor;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public final class MoveResourcesRefactoringContribution
extends RefactoringContribution {
    private static final String ATTRIBUTE_NUMBER_OF_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENT = "element";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_UPDATE_REFERENCES = "updateReferences";

    @Override
    public Map<String, String> retrieveArgumentMap(RefactoringDescriptor descriptor) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (descriptor instanceof MoveResourcesDescriptor) {
            MoveResourcesDescriptor moveDescriptor = (MoveResourcesDescriptor)descriptor;
            IPath[] paths = moveDescriptor.getResourcePathsToMove();
            String project = moveDescriptor.getProject();
            IPath destinationPath = moveDescriptor.getDestinationPath();
            map.put(ATTRIBUTE_NUMBER_OF_RESOURCES, String.valueOf(paths.length));
            int i = 0;
            while (i < paths.length) {
                map.put(ATTRIBUTE_ELEMENT + (i + 1), ResourceProcessors.resourcePathToHandle(project, paths[i]));
                ++i;
            }
            map.put(ATTRIBUTE_DESTINATION, ResourceProcessors.resourcePathToHandle(project, destinationPath));
            map.put(ATTRIBUTE_UPDATE_REFERENCES, moveDescriptor.isUpdateReferences() ? "true" : "false");
            return map;
        }
        return null;
    }

    @Override
    public RefactoringDescriptor createDescriptor() {
        return new MoveResourcesDescriptor();
    }

    @Override
    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map<String, String> arguments, int flags) {
        try {
            int numResources = Integer.parseInt(arguments.get(ATTRIBUTE_NUMBER_OF_RESOURCES));
            if (numResources < 0 || numResources > 100000) {
                throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, number of moved elements invalid");
            }
            IPath[] resourcePaths = new IPath[numResources];
            int i = 0;
            while (i < numResources) {
                String resource = arguments.get(ATTRIBUTE_ELEMENT + String.valueOf(i + 1));
                if (resource == null) {
                    throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, resource missing");
                }
                resourcePaths[i] = ResourceProcessors.handleToResourcePath(project, resource);
                ++i;
            }
            String destination = arguments.get(ATTRIBUTE_DESTINATION);
            if (destination == null) {
                throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map, destination missing");
            }
            IPath destPath = ResourceProcessors.handleToResourcePath(project, destination);
            boolean updateReferences = "true".equals(arguments.get(ATTRIBUTE_UPDATE_REFERENCES));
            MoveResourcesDescriptor descriptor = new MoveResourcesDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setResourcePathsToMove(resourcePaths);
            descriptor.setDestinationPath(destPath);
            descriptor.setUpdateReferences(updateReferences);
            return descriptor;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can not restore MoveResourceDescriptor from map");
        }
    }
}

