/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Objects;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class Homebrew {
    public static final String ENV_HOMEBREW_HOME = "HOMEBREW_HOME";
    private static final String ENV_PATH = "PATH";
    private static String envPathValueCached = null;
    private static String envHomebrewHomeValueCached = null;
    private static String homebrewLocation = null;
    private static boolean isHomebrewLocationCached = false;

    private static String findHomebrewRoot(String envPathValue, String envHomebrewHomeValue) {
        String homebrewPath;
        if (envHomebrewHomeValue != null && !envHomebrewHomeValue.isEmpty() && Homebrew.installationExists(homebrewPath = envHomebrewHomeValue)) {
            return homebrewPath;
        }
        String defaultHomebrewPath = Homebrew.getDefaultHomebrewPath();
        if (defaultHomebrewPath != null && Homebrew.installationExists(defaultHomebrewPath)) {
            return defaultHomebrewPath;
        }
        return null;
    }

    private static boolean installationExists(String homebrewHomeDir) {
        return new Path(homebrewHomeDir).append("bin").toFile().isDirectory();
    }

    private static String getDefaultHomebrewPath() {
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        if ("macosx".equals(os)) {
            if ("aarch64".equals(arch)) {
                return "/opt/homebrew";
            }
            if ("x86_64".equals(arch)) {
                return "/usr/local";
            }
        } else if ("linux".equals(os) && "x86_64".equals(arch)) {
            return "/home/linuxbrew/.linuxbrew";
        }
        return null;
    }

    public static String getHomebrewHome() {
        String envHomebrewHomeValue;
        IEnvironmentVariable varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, (ICConfigurationDescription)null, true);
        String envPathValue = varPath != null ? varPath.getValue() : null;
        IEnvironmentVariable varHomebrewHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_HOMEBREW_HOME, (ICConfigurationDescription)null, true);
        String string = envHomebrewHomeValue = varHomebrewHome != null ? varHomebrewHome.getValue() : null;
        if (isHomebrewLocationCached && Objects.equals(envPathValue, envPathValueCached) && Objects.equals(envHomebrewHomeValue, envHomebrewHomeValueCached)) {
            return homebrewLocation;
        }
        homebrewLocation = Homebrew.findHomebrewRoot(envPathValue, envHomebrewHomeValue);
        envPathValueCached = envPathValue;
        envHomebrewHomeValueCached = envHomebrewHomeValue;
        isHomebrewLocationCached = true;
        return homebrewLocation;
    }
}

