/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class TmfEditorInput
implements IEditorInput {
    private final IFile fFile;
    private final ITmfTrace fTrace;

    public TmfEditorInput(IFile file, ITmfTrace trace) {
        this.fFile = file;
        this.fTrace = trace;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        IContentType contentType = IDE.getContentType((IFile)this.fFile);
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fFile.getName(), contentType);
    }

    public String getName() {
        return this.fTrace.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFile.getFullPath().makeRelative().toString();
    }

    public IFile getFile() {
        return this.fFile;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fFile == null ? 0 : this.fFile.getLocation().hashCode());
        result = 31 * result + (this.fTrace == null ? 0 : this.fTrace.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfEditorInput other = (TmfEditorInput)obj;
        if (this.fFile == null ? other.fFile != null : !this.fFile.getLocation().equals((Object)other.fFile.getLocation())) {
            return false;
        }
        return !(this.fTrace == null ? other.fTrace != null : !this.fTrace.getName().equals(other.fTrace.getName()));
    }
}

