/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.perf;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.junit.Test;

public abstract class XmlAnalysisPerfBenchmark {
    private static final String TEST_ID = "org.eclipse.tracecompass.xml.analysis#XML analysis#%s (%s)";
    private final String fTestName;
    private final String fXmlFile;
    private final @NonNull String fAnalysisId;
    private final int fLoopCount;

    protected abstract @NonNull ITmfTrace getTrace() throws TmfTraceException;

    public XmlAnalysisPerfBenchmark(String testName, String absoluteFilePath, @NonNull String moduleId, int loopCount) {
        this.fTestName = testName;
        this.fXmlFile = absoluteFilePath;
        this.fAnalysisId = moduleId;
        this.fLoopCount = loopCount;
    }

    @Test
    public void testAnalysisPerformance() throws TmfTraceException, TmfAnalysisException {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(String.format(TEST_ID, this.fAnalysisId, this.fTestName));
        perf.tagAsSummary(pm, "XML analysis: " + this.fAnalysisId + " " + this.fTestName, Dimension.CPU_TIME);
        int i = 0;
        while (i < this.fLoopCount) {
            ITmfTrace trace = null;
            TmfAbstractAnalysisModule module = null;
            try {
                trace = this.getTrace();
                module = TmfXmlTestUtils.getModuleInFile(this.fXmlFile, this.fAnalysisId);
                module.setTrace(trace);
                pm.start();
                TmfTestHelper.executeAnalysis((IAnalysisModule)module);
                pm.stop();
                if (i == 0) {
                    System.out.println(module.getProperties());
                }
                File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                File[] fileArray = suppDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            finally {
                if (trace != null) {
                    trace.dispose();
                }
                if (module != null) {
                    module.dispose();
                }
            }
            ++i;
        }
        pm.commit();
    }
}

