/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.stubs.backend;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.List;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.classic.CoreNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.classic.HistoryTreeClassic;
import org.junit.Assert;

public class HistoryTreeClassicStub
extends HistoryTreeClassic {
    public static final int MINIMUM_BLOCK_SIZE = 4096;

    public HistoryTreeClassicStub(HTConfig conf) throws IOException {
        super(conf);
    }

    public HistoryTreeClassicStub(File existingStateFile, int expProviderVersion) throws IOException {
        super(existingStateFile, expProviderVersion);
    }

    public List<HTNode> getLatestBranch() {
        return (List)NonNullUtils.checkNotNull((Object)super.getLatestBranch());
    }

    public HTNode getLatestLeaf() {
        List<HTNode> latest = this.getLatestBranch();
        return (HTNode)Iterables.getLast(latest);
    }

    public HTNode getNodeAt(int pos) {
        List<HTNode> latest = this.getLatestBranch();
        return latest.get(pos);
    }

    public int getDepth() {
        return this.getLatestBranch().size();
    }

    public void debugPrintFullTree(PrintWriter writer, boolean printIntervals, long ts) {
        this.preOrderPrint(writer, false, this.getLatestBranch().get(0), 0, ts);
        if (printIntervals) {
            this.preOrderPrint(writer, true, this.getLatestBranch().get(0), 0, ts);
        }
        writer.println('\n');
    }

    private void preOrderPrint(PrintWriter writer, boolean printIntervals, HTNode currentNode, int curDepth, long ts) {
        writer.println(currentNode.toString());
        if (printIntervals && (ts <= 0L || ts >= currentNode.getNodeStart() && ts <= currentNode.getNodeEnd())) {
            currentNode.debugPrintIntervals(writer);
        }
        switch (currentNode.getNodeType()) {
            case LEAF: {
                return;
            }
            case CORE: {
                try {
                    CoreNode node = (CoreNode)currentNode;
                    int i = 0;
                    while (i < node.getNbChildren()) {
                        HTNode nextNode = this.getTreeIO().readNode(node.getChild(i));
                        int j = 0;
                        while (j < curDepth) {
                            writer.print("  ");
                            ++j;
                        }
                        writer.print("+-");
                        this.preOrderPrint(writer, printIntervals, nextNode, curDepth + 1, ts);
                        ++i;
                    }
                }
                catch (ClosedChannelException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
                break;
            }
        }
    }

    public void assertIntegrity() {
        try {
            int i = 0;
            while (i < this.getNodeCount()) {
                this.assertNodeIntegrity(this.getNode(i));
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void assertNodeIntegrity(HTNode node) {
        if (node instanceof ParentNode) {
            this.assertChildrenIntegrity((ParentNode)node);
        }
    }

    private void assertChildrenIntegrity(ParentNode node) {
        try {
            if (node.getNbChildren() > 0) {
                HTNode childNode = this.getNode(node.getChild(0));
                Assert.assertEquals((String)("Equals start time of parent " + node.getSequenceNumber() + " and first child " + childNode.getSequenceNumber()), (long)node.getNodeStart(), (long)childNode.getNodeStart());
                if (node.isOnDisk()) {
                    childNode = this.getNode(node.getLatestChild());
                    Assert.assertEquals((String)("Equals end time of parent " + node.getSequenceNumber() + " and last child " + childNode.getSequenceNumber()), (long)node.getNodeEnd(), (long)childNode.getNodeEnd());
                }
            }
            int i = 0;
            while (i < node.getNbChildren()) {
                HTNode childNode = this.getNode(node.getChild(i));
                Assert.assertEquals((String)("Start time in parent " + node.getSequenceNumber() + " of child at index " + i), (long)childNode.getNodeStart(), (long)node.getChildStart(i));
                Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " has correct start time"), (node.getNodeStart() <= childNode.getNodeStart() ? 1 : 0) != 0);
                if (node.isOnDisk() && childNode.isOnDisk()) {
                    Assert.assertTrue((String)("Child at index " + i + " of parent " + node.getSequenceNumber() + " has correct end time"), (childNode.getNodeEnd() <= node.getNodeEnd() ? 1 : 0) != 0);
                    Assert.assertEquals((String)("End time in parent " + node.getSequenceNumber() + " of child at index " + i), (long)childNode.getNodeEnd(), (long)node.getChildEnd(i));
                }
                HistoryTreeClassicStub.testIntersectingChildren(node, childNode);
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static void testIntersectingChildren(ParentNode parent, HTNode child) {
        int childSequence = child.getSequenceNumber();
        long t = parent.getNodeStart();
        while (t < parent.getNodeEnd()) {
            boolean shouldBeInCollection = t >= child.getNodeStart() && t <= child.getNodeEnd();
            Collection nextChildren = parent.selectNextChildren(t);
            Assert.assertEquals((Object)shouldBeInCollection, (Object)nextChildren.contains(childSequence));
            ++t;
        }
    }
}

