/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.LoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceLoggerPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class TraceLoggerComponent
extends TraceControlComponent {
    public static final String TRACE_LOGGER_ICON_FILE_ENABLED = "icons/obj16/logger_enabled.gif";
    public static final String TRACE_LOGGER_ICON_FILE_DISABLED = "icons/obj16/logger_disabled.gif";
    protected ILoggerInfo fLoggerInfo = null;
    private Image fDisabledImage = null;

    public TraceLoggerComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_LOGGER_ICON_FILE_ENABLED);
        this.setToolTip(Messages.TraceControl_LoggerDisplayName);
        this.fLoggerInfo = new LoggerInfo(name);
        this.fDisabledImage = Activator.getDefault().loadIcon(TRACE_LOGGER_ICON_FILE_DISABLED);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySource.class) {
            return adapter.cast(new TraceLoggerPropertySource(this));
        }
        return null;
    }

    public void setLoggerInfo(ILoggerInfo loggerInfo) {
        this.fLoggerInfo = loggerInfo;
    }

    @Override
    public Image getImage() {
        if (this.fLoggerInfo.getState() == TraceEnablement.DISABLED) {
            return this.fDisabledImage;
        }
        return super.getImage();
    }

    public TraceEnablement getState() {
        return this.fLoggerInfo.getState();
    }

    public void setState(TraceEnablement state) {
        this.fLoggerInfo.setState(state);
    }

    public void setState(String stateName) {
        this.fLoggerInfo.setState(stateName);
    }

    public ITraceLogLevel getLogLevel() {
        return this.fLoggerInfo.getLogLevel();
    }

    public void setLogLevel(ITraceLogLevel level) {
        this.fLoggerInfo.setLogLevel(level);
    }

    public void setLogLevel(String levelName) {
        this.fLoggerInfo.setLogLevel(levelName);
    }

    public LogLevelType getLogLevelType() {
        return this.fLoggerInfo.getLogLevelType();
    }

    public void setLogLevelType(LogLevelType levelType) {
        this.fLoggerInfo.setLogLevelType(levelType);
    }

    public TargetNodeComponent getTargetNode() {
        return ((TraceDomainComponent)this.getParent()).getTargetNode();
    }

    public String getSessionName() {
        return ((TraceDomainComponent)this.getParent()).getSessionName();
    }

    public TraceSessionComponent getSession() {
        return ((TraceDomainComponent)this.getParent()).getSession();
    }

    public TraceDomainType getDomain() {
        return ((TraceDomainComponent)this.getParent()).getDomain();
    }
}

