/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.ui.RemoteUIImages;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractRemoteUIConnectionService
implements IRemoteUIConnectionService {
    @Override
    public void openConnectionWithProgress(Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        if (!connection.isOpen()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        throw new InvocationTargetException(e);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                if (context != null) {
                    context.run(true, true, op);
                } else {
                    new ProgressMonitorDialog(shell).run(true, true, op);
                }
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.AbstractRemoteUIConnectionManager_Connection_Error, (String)Messages.AbstractRemoteUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, "org.eclipse.remote.ui", e.getCause().getMessage()));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.AbstractRemoteUIConnectionManager_Connection_Error, (String)Messages.AbstractRemoteUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, "org.eclipse.remote.ui", e.getMessage()));
            }
        }
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return new DefaultLabelProvider();
    }

    protected static class DefaultLabelProvider
    extends LabelProvider {
        protected DefaultLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IRemoteConnection) {
                return ((IRemoteConnection)element).getName();
            }
            if (element instanceof IRemoteConnectionType) {
                return ((IRemoteConnectionType)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IRemoteConnection || element instanceof IRemoteConnectionType) {
                return RemoteUIImages.get("org.eclipse.remote.ui.defaultType");
            }
            return super.getImage(element);
        }
    }
}

