/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.commands.actions.DebugCommandService;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleTerminateAction
extends Action
implements IUpdate {
    private ProcessConsole fConsole;
    private final IWorkbenchWindow fWindow;

    public ConsoleTerminateAction(IWorkbenchWindow window, ProcessConsole console) {
        super(ConsoleMessages.ConsoleTerminateAction_0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.console_terminate_action_context");
        this.fConsole = console;
        this.fWindow = window;
        this.setToolTipText(ConsoleMessages.ConsoleTerminateAction_1);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_TERMINATE"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_TERMINATE"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_TERMINATE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.console_terminate_action_context");
        this.update();
    }

    public void update() {
        IProcess process = this.fConsole.getProcess();
        this.setEnabled(process.canTerminate());
    }

    public void run() {
        IProcess process = this.fConsole.getProcess();
        List<ITerminate> targets = this.collectTargets(process);
        targets.add((ITerminate)process);
        DebugCommandService service = DebugCommandService.getService(this.fWindow);
        service.executeCommand(ITerminateHandler.class, targets.toArray(), null);
    }

    private List<ITerminate> collectTargets(IProcess process) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ArrayList<ITerminate> targets = new ArrayList<ITerminate>();
        ILaunch[] iLaunchArray = launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            IProcess[] iProcessArray = launch.getProcesses();
            int n3 = iProcessArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IProcess proc = iProcessArray[n4];
                if (proc.equals(process)) {
                    IDebugTarget[] debugTargets = launch.getDebugTargets();
                    Collections.addAll(targets, debugTargets);
                    return targets;
                }
                ++n4;
            }
            ++n2;
        }
        return targets;
    }

    public void dispose() {
        this.fConsole = null;
    }
}

