/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ClearTraceOffsetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final HashSet<TmfTraceElement> traceElements = new HashSet<TmfTraceElement>();
        if (selection instanceof StructuredSelection) {
            for (Object element : (StructuredSelection)selection) {
                if (element instanceof TmfTraceElement) {
                    TmfTraceElement trace = (TmfTraceElement)element;
                    traceElements.add(trace.getElementUnderTraceFolder());
                    continue;
                }
                if (element instanceof TmfExperimentElement) {
                    TmfExperimentElement exp = (TmfExperimentElement)element;
                    for (TmfTraceElement trace : exp.getTraces()) {
                        traceElements.add(trace.getElementUnderTraceFolder());
                    }
                    continue;
                }
                if (!(element instanceof TmfTraceFolder)) continue;
                TmfTraceFolder folder = (TmfTraceFolder)element;
                traceElements.addAll(folder.getTraces());
            }
        }
        if (traceElements.isEmpty()) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        MessageBox mb = new MessageBox(shell, 292);
        mb.setText(Messages.ClearTraceOffsetHandler_Title);
        mb.setMessage(Messages.ClearTraceOffsetHandler_ConfirmMessage);
        if (mb.open() != 32) {
            return null;
        }
        TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                for (TmfTraceElement trace : traceElements) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (TimestampTransformFactory.getTimestampTransform((IResource)trace.getResource()).equals(TimestampTransformFactory.getDefaultTransform())) continue;
                    Display.getDefault().syncExec(trace::closeEditors);
                    trace.deleteSupplementaryResources();
                    TimestampTransformFactory.setTimestampTransform((IResource)trace.getResource(), null);
                    trace.refreshSupplementaryFolder();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(e.toString(), e.getTargetException().toString());
        }
        return null;
    }
}

