/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;

public class DataDrivenScenarioHistoryBuilder {
    public static final String STATUS = "status";
    public static final String SCENARIO_COUNT = "nbScenarios";
    private static final String START_TIME = "startTime";
    private static final String ERROR_MESSAGE = "The state system is null";
    private final Map<String, TmfAttributePool> fFsmPools = new HashMap<String, TmfAttributePool>();
    protected static final BiMap<ScenarioStatusType, ITmfStateValue> STATUS_MAP = ImmutableBiMap.of((Object)((Object)ScenarioStatusType.PENDING), (Object)TmfStateValue.newValueInt((int)0), (Object)((Object)ScenarioStatusType.IN_PROGRESS), (Object)TmfStateValue.newValueInt((int)1), (Object)((Object)ScenarioStatusType.MATCHED), (Object)TmfStateValue.newValueInt((int)2), (Object)((Object)ScenarioStatusType.ABANDONED), (Object)TmfStateValue.newValueInt((int)3));

    public long getStartTime(IAnalysisDataContainer container, DataDrivenScenarioInfo info, ITmfEvent event) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        try {
            int attributeQuark = DataDrivenScenarioHistoryBuilder.getQuarkRelativeAndAdd(ss, info.getQuark(), START_TIME);
            ITmfStateInterval state = ss.querySingleState(ts, attributeQuark);
            return state.getStartTime();
        }
        catch (StateSystemDisposedException e) {
            Activator.logError("failed to get the start time of the scenario", e);
            return -1L;
        }
    }

    public void updateStoredFields(IAnalysisDataContainer container, String attributeName, ITmfStateValue value, DataDrivenScenarioInfo info, ITmfEvent event) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        try {
            int attributeQuark = DataDrivenScenarioHistoryBuilder.getQuarkRelativeAndAdd(ss, info.getQuark(), "storedFields", attributeName);
            ss.modifyAttribute(ts, value.unboxValue(), attributeQuark);
        }
        catch (StateValueTypeException e) {
            Activator.logError("failed to save the stored field " + attributeName, e);
        }
    }

    public void resetStoredFields(IAnalysisDataContainer container, String attributeName, DataDrivenScenarioInfo info, ITmfEvent event) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        try {
            int attributeQuark = DataDrivenScenarioHistoryBuilder.getQuarkRelativeAndAdd(ss, info.getQuark(), "storedFields", attributeName);
            ss.modifyAttribute(ts, null, attributeQuark);
        }
        catch (StateValueTypeException e) {
            Activator.logError("failed to clear the stored fields", e);
        }
    }

    public ITmfStateValue getStoredFieldValue(IAnalysisDataContainer container, String attributeName, DataDrivenScenarioInfo info, ITmfEvent event) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = event.getTimestamp().toNanos();
        ITmfStateInterval state = null;
        try {
            int attributeQuark = DataDrivenScenarioHistoryBuilder.getQuarkRelativeAndAdd(ss, info.getQuark(), "storedFields", attributeName);
            state = ss.querySingleState(ts, attributeQuark);
        }
        catch (StateSystemDisposedException e) {
            Activator.logError("failed to get the value of the stored field " + attributeName, e);
        }
        return state != null ? (ITmfStateValue)NonNullUtils.checkNotNull((Object)state.getStateValue()) : TmfStateValue.nullValue();
    }

    protected TmfAttributePool getPoolFor(IAnalysisDataContainer container, String fsmId) {
        TmfAttributePool pool = this.fFsmPools.get(fsmId);
        if (pool != null) {
            return pool;
        }
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)((ITmfStateSystemBuilder)container.getStateSystem()));
        String[] fsmPath = new String[]{"scenarios", fsmId};
        int quark = DataDrivenScenarioHistoryBuilder.getQuarkAbsoluteAndAdd(ss, fsmPath);
        pool = new TmfAttributePool(ss, Integer.valueOf(quark));
        this.fFsmPools.put(fsmId, pool);
        return pool;
    }

    public int assignScenarioQuark(IAnalysisDataContainer container, DataDrivenFsm fsm) {
        TmfAttributePool pool = this.getPoolFor(container, fsm.getId());
        return pool.getAvailable();
    }

    public int getScenarioStatusQuark(IAnalysisDataContainer container, int scenarioQuark) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        return DataDrivenScenarioHistoryBuilder.getQuarkRelativeAndAdd(ss, scenarioQuark, STATUS);
    }

    public long getSpecificStateStartTime(IXmlStateSystemContainer container, String stateName, DataDrivenScenarioInfo info, ITmfEvent event) {
        long ts = event.getTimestamp().getValue();
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        try {
            int attributeQuark = DataDrivenScenarioHistoryBuilder.getQuarkRelativeAndAdd(ss, info.getQuark(), "state", stateName, START_TIME);
            ITmfStateInterval state = ss.querySingleState(ts, attributeQuark);
            return state.getStartTime();
        }
        catch (StateSystemDisposedException e) {
            Activator.logError("failed the start time of the state " + stateName, e);
            return -1L;
        }
    }

    private static int getQuarkAbsoluteAndAdd(@Nullable ITmfStateSystemBuilder ss, String ... path) {
        if (ss == null) {
            throw new NullPointerException(ERROR_MESSAGE);
        }
        return ss.getQuarkAbsoluteAndAdd(path);
    }

    private static int getQuarkRelativeAndAdd(@Nullable ITmfStateSystemBuilder ss, int startNodeQuark, String ... path) {
        if (ss == null) {
            throw new NullPointerException(ERROR_MESSAGE);
        }
        return ss.getQuarkRelativeAndAdd(startNodeQuark, path);
    }

    public void update(IAnalysisDataContainer container, DataDrivenScenarioInfo info, @Nullable ITmfEvent event) {
        DataDrivenScenarioHistoryBuilder.updateScenarioSpecificStateStartTime(event, container, info);
        DataDrivenScenarioHistoryBuilder.updateScenarioState(event, container, info);
        DataDrivenScenarioHistoryBuilder.updateScenarioStatus(event, container, info);
    }

    private static void updateScenarioStatus(@Nullable ITmfEvent event, IAnalysisDataContainer container, DataDrivenScenarioInfo info) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        try {
            TmfStateValue value;
            switch (info.getStatus()) {
                case IN_PROGRESS: {
                    value = (ITmfStateValue)STATUS_MAP.get((Object)ScenarioStatusType.IN_PROGRESS);
                    break;
                }
                case ABANDONED: {
                    value = (ITmfStateValue)STATUS_MAP.get((Object)ScenarioStatusType.ABANDONED);
                    break;
                }
                case MATCHED: {
                    value = (ITmfStateValue)STATUS_MAP.get((Object)ScenarioStatusType.MATCHED);
                    break;
                }
                case PENDING: {
                    value = (ITmfStateValue)STATUS_MAP.get((Object)ScenarioStatusType.PENDING);
                    break;
                }
                default: {
                    value = TmfStateValue.nullValue();
                }
            }
            ss.modifyAttribute(ts, ((ITmfStateValue)NonNullUtils.checkNotNull((Object)value)).unboxValue(), info.getStatusQuark());
        }
        catch (StateValueTypeException stateValueTypeException) {
            Activator.logError("failed to update scenario status");
        }
    }

    private static long getTimestamp(@Nullable ITmfEvent event, @Nullable ITmfStateSystemBuilder ss) {
        if (event != null) {
            return event.getTimestamp().toNanos();
        }
        if (ss != null) {
            return ss.getCurrentEndTime();
        }
        throw new IllegalArgumentException("Event and state system cannot be null at the same time.");
    }

    private static void updateScenarioState(@Nullable ITmfEvent event, IAnalysisDataContainer container, DataDrivenScenarioInfo info) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        try {
            int attributeQuark = ss.getQuarkRelativeAndAdd(info.getQuark(), new String[]{"state"});
            ss.modifyAttribute(ts, (Object)info.getActiveState().getId(), attributeQuark);
        }
        catch (StateValueTypeException stateValueTypeException) {
            Activator.logError("failed to update scenario state");
        }
    }

    private static void updateScenarioSpecificStateStartTime(@Nullable ITmfEvent event, IAnalysisDataContainer container, DataDrivenScenarioInfo info) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        try {
            int stateQuark = ss.getQuarkRelativeAndAdd(info.getQuark(), new String[]{"state"});
            String activeState = ss.queryOngoingState(stateQuark).unboxStr();
            if (activeState.compareTo(info.getActiveState().getId()) != 0) {
                int attributeQuark = ss.getQuarkRelativeAndAdd(stateQuark, new String[]{info.getActiveState().getId(), START_TIME});
                ss.modifyAttribute(ts, (Object)ts, attributeQuark);
            }
        }
        catch (StateValueTypeException stateValueTypeException) {
            Activator.logError("failed to update the start time of the state");
        }
    }

    public void startScenario(IAnalysisDataContainer container, DataDrivenScenarioInfo info, ITmfEvent event) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        try {
            int attributeQuark = ss.getQuarkRelativeAndAdd(info.getQuark(), new String[]{START_TIME});
            ss.modifyAttribute(ts, (Object)ts, attributeQuark);
        }
        catch (StateValueTypeException stateValueTypeException) {
            Activator.logError("failed to update the start time of the scenario");
        }
    }

    public void completeScenario(IAnalysisDataContainer container, DataDrivenScenarioInfo info, @Nullable ITmfEvent event) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)container.getStateSystem();
        long ts = DataDrivenScenarioHistoryBuilder.getTimestamp(event, ss);
        DataDrivenFsm fsm = info.getFsm();
        if (fsm == null) {
            return;
        }
        TmfAttributePool pool = this.getPoolFor(container, fsm.getId());
        pool.recycle(info.getQuark(), ts);
        info.recycleAttributes(ts);
    }

    public static enum ScenarioStatusType {
        PENDING,
        IN_PROGRESS,
        ABANDONED,
        MATCHED;

    }
}

