/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.UUID;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFTraceTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private CTFTrace fixture;

    @Before
    public void setUp() {
        try {
            this.fixture = CtfTestTraceUtils.getTrace(testTrace);
        }
        catch (CTFException cTFException) {
            Assert.fail();
        }
        this.fixture.setMinor(1L);
        this.fixture.setUUID(UUID.randomUUID());
        this.fixture.setPacketHeader(new StructDeclaration(1L));
        this.fixture.setMajor(1L);
        this.fixture.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Test
    public void testOpen_existing() {
        try {
            CTFTrace result = CtfTestTraceUtils.getTrace(testTrace);
            Assert.assertNotNull((Object)result.getUUID());
        }
        catch (CTFException cTFException) {
            Assert.fail();
        }
    }

    @Test(expected=CTFException.class)
    public void testOpen_invalid() throws CTFException {
        File path = new File("");
        CTFTrace result = new CTFTrace(path);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testUUIDIsSet() {
        boolean result = this.fixture.uuidIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testAddStream() {
        int nbStreams = this.fixture.nbStreams();
        Assert.assertEquals((long)1L, (long)nbStreams);
        try {
            CTFStream stream = new CTFStream(CtfTestTraceUtils.getTrace(testTrace));
            stream.setId(1234L);
            this.fixture.addStream((ICTFStream)stream);
        }
        catch (CTFException cTFException) {
            Assert.fail();
        }
        catch (ParseException parseException) {
            Assert.fail();
        }
        nbStreams = this.fixture.nbStreams();
        Assert.assertEquals((long)2L, (long)nbStreams);
    }

    @Test
    public void testByteOrderIsSet() {
        boolean result = this.fixture.byteOrderIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testGetByteOrder_1() {
        ByteOrder result = this.fixture.getByteOrder();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetMajor() {
        long result = this.fixture.getMajor();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testGetMinor() {
        long result = this.fixture.getMinor();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testGetPacketHeader() {
        StructDeclaration result = this.fixture.getPacketHeader();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetPath() {
        String result = this.fixture.getPath();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetStream() {
        Long id = 0L;
        ICTFStream result = this.fixture.getStream(id);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetTraceDirectory() {
        File result = this.fixture.getTraceDirectory();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetUUID() {
        UUID result = this.fixture.getUUID();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testLookupDefinition() {
        String lookupPath = "trace.packet.header";
        Definition result = this.fixture.lookupDefinition(lookupPath);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testMajorIsSet() {
        boolean result = this.fixture.majorIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testMinorIsSet() {
        boolean result = this.fixture.minorIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPacketHeaderIsSet_valid() {
        boolean result = this.fixture.packetHeaderIsSet();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPacketHeaderIsSet_invalid() {
        try {
            CTFTrace fixture2 = CtfTestTraceUtils.getTrace(testTrace);
            fixture2.setMinor(1L);
            fixture2.setUUID(UUID.randomUUID());
            fixture2.setPacketHeader(null);
            fixture2.setMajor(1L);
            fixture2.setByteOrder(ByteOrder.BIG_ENDIAN);
            boolean result = fixture2.packetHeaderIsSet();
            Assert.assertFalse((boolean)result);
        }
        catch (CTFException cTFException) {
            Assert.fail();
        }
    }

    @Test
    public void testSetByteOrder() {
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        this.fixture.setByteOrder(byteOrder);
    }

    @Test
    public void testSetMajor() {
        long major = 1L;
        this.fixture.setMajor(major);
    }

    @Test
    public void testSetMinor() {
        long minor = 1L;
        this.fixture.setMinor(minor);
    }

    @Test
    public void testSetPacketHeader() {
        StructDeclaration packetHeader = new StructDeclaration(1L);
        this.fixture.setPacketHeader(packetHeader);
    }

    @Test
    public void testSetUUID() {
        UUID uuid = UUID.randomUUID();
        this.fixture.setUUID(uuid);
    }

    @Test
    public void testGetSetClock_1() {
        String name = "clockyClock";
        this.fixture.addClock(name, new CTFClock());
        CTFClock result = this.fixture.getClock(name);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetSetClock_2() {
        String name = "";
        CTFClock ctfClock = new CTFClock();
        ctfClock.addAttribute("name", (Object)"Bob");
        ctfClock.addAttribute("pi", (Object)Math.PI);
        this.fixture.addClock(name, ctfClock);
        CTFClock result = this.fixture.getClock(name);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue(((Double)ctfClock.getProperty("pi") > 3.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ctfClock.getName().equals("Bob"));
    }

    @Test
    public void testLookupEnvironment_1() {
        String key = "";
        String result = (String)this.fixture.getEnvironment().get(key);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupEnvironment_2() {
        String key = "otherTest";
        String result = (String)this.fixture.getEnvironment().get(key);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupEnvironment_3() {
        String key = "test";
        this.fixture.setEnvironment((Map)ImmutableMap.of((Object)key, (Object)key));
        String result = (String)this.fixture.getEnvironment().get(key);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)key, (Object)result);
    }

    @Test
    public void testLookupEnvironment_4() {
        String key = "test";
        this.fixture.setEnvironment((Map)ImmutableMap.of((Object)key, (Object)"bozo"));
        String result = (String)this.fixture.getEnvironment().get(key);
        Assert.assertNotNull((Object)result);
    }
}

