/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.shared;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.eclipse.tracecompass.ctf.core.tests.CtfCoreTestPlugin;

public class LttngTraceGenerator {
    private static final String metadataKernel = "/* CTF 1.8 */ \ntypealias integer { size = 8; align = 8; signed = false; } := uint8_t;\ntypealias integer { size = 16; align = 8; signed = false; } := uint16_t;\ntypealias integer { size = 32; align = 8; signed = false; } := uint32_t;\ntypealias integer { size = 64; align = 8; signed = false; } := uint64_t;\ntypealias integer { size = 32; align = 8; signed = false; } := unsigned long;\ntypealias integer { size = 5; align = 1; signed = false; } := uint5_t;\ntypealias integer { size = 27; align = 1; signed = false; } := uint27_t;\n\ntrace {\n   major = 1;\n   minor = 8;\n   uuid = \"11111111-1111-1111-1111-111111111111\";\n   byte_order = le;\n   packet.header := struct {\n       uint32_t magic;\n       uint8_t  uuid[16];\n       uint32_t stream_id;\n   };\n};\n\nenv {\n   hostname = \"synthetic-host\";\n   domain = \"kernel\";\n   sysname = \"FakeLinux\";\n   kernel_release = \"1.0\";\n   kernel_version = \"Fake Os Synthetic Trace\";\n   tracer_name = \"lttng-modules\";\n   tracer_major = 2;\n   tracer_minor = 1;\n   tracer_patchlevel = 0;\n};\n\nclock {\n   name = monotonic;\n   uuid = \"bbff68f0-c633-4ea1-92cd-bd11024ec4de\";\n   description = \"Monotonic Clock\";\n   freq = 1000000000; /* Frequency, in Hz */\n   /* clock value offset from Epoch is: offset * (1/freq) */\n   offset = 1368000272650993664;\n};\n\ntypealias integer {\n   size = 27; align = 1; signed = false;\n   map = clock.monotonic.value;\n} := uint27_clock_monotonic_t;\n\ntypealias integer {\n   size = 32; align = 8; signed = false;\n   map = clock.monotonic.value;\n} := uint32_clock_monotonic_t;\n\ntypealias integer {\n   size = 64; align = 8; signed = false;\n   map = clock.monotonic.value;\n} := uint64_clock_monotonic_t;\n\nstruct packet_context {\n   uint64_clock_monotonic_t timestamp_begin;\n   uint64_clock_monotonic_t timestamp_end;\n   uint64_t content_size;\n   uint64_t packet_size;\n   unsigned long events_discarded;\n   uint32_t cpu_id;\n};\n\nstruct event_header_compact {\n   enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n   variant <id> {\n       struct {\n           uint27_clock_monotonic_t timestamp;\n       } compact;\n       struct {\n           uint32_t id;\n           uint64_clock_monotonic_t timestamp;\n       } extended;\n   } v;\n} align(8);\n\nstruct event_header_large {\n   enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n   variant <id> {\n       struct {\n           uint32_clock_monotonic_t timestamp;\n       } compact;\n       struct {\n           uint32_t id;\n           uint64_clock_monotonic_t timestamp;\n       } extended;\n   } v;\n} align(8);\n\nstream {\n   id = 0;\n   event.header := struct event_header_compact;\n   packet.context := struct packet_context;\n};\n\nevent {\n   name = sched_switch;\n   id = 0;\n   stream_id = 0;\n   fields := struct {\n       integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _prev_comm[16];\n       integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _prev_tid;\n       integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _prev_prio;\n       integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _prev_state;\n       integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _next_comm[16];\n       integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _next_tid;\n       integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _next_prio;\n   };\n};\n\n";
    private final List<String> fProcesses = Arrays.asList(sfProcesses);
    private final long fDuration;
    private final long fNbEvents;
    private final int fNbChans;
    private final String metadata;
    private static final String[] sfProcesses = new String[]{"IDLE", "gnuplot", "starcraft 2:pt3", "bash", "smash", "thrash", "fireball", "Half-life 3", "ST: The game"};
    private static final String TRACES_DIRECTORY = "traces";
    private static final String TRACE_NAME = "synthetic-trace";

    public static void main(String[] args) {
        String path = String.valueOf(CtfCoreTestPlugin.getTemporaryDirPath()) + File.separator + TRACE_NAME;
        LttngTraceGenerator.generateLttngTrace(new File(path));
    }

    public static String getName() {
        return TRACE_NAME;
    }

    public static String getPath() {
        CtfCoreTestPlugin plugin = CtfCoreTestPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        Path tracePath = Paths.get("..", "..", "ctf", "org.eclipse.tracecompass.ctf.core.tests", TRACES_DIRECTORY, TRACE_NAME);
        tracePath = tracePath.toAbsolutePath();
        File file = tracePath.toFile();
        LttngTraceGenerator.generateLttngTrace(file);
        return file.getAbsolutePath();
    }

    public static void generateLttngTrace(File file) {
        LttngTraceGenerator gt = new LttngTraceGenerator(0xAAAAAAAL, 20833L, 25);
        gt.writeTrace(file);
    }

    public LttngTraceGenerator(long duration, long events, int nbChannels) {
        this(duration, events, nbChannels, true);
    }

    public LttngTraceGenerator(long duration, long events, int nbChannels, boolean isKernel) {
        this.fDuration = duration;
        this.fNbEvents = events;
        this.fNbChans = nbChannels;
        this.metadata = isKernel ? metadataKernel : LttngTraceGenerator.getMetadataUST();
    }

    public void writeTrace(File file) {
        if (file.exists()) {
            LttngTraceGenerator.deleteDirectory(file);
        }
        file.mkdir();
        File metadataFile = new File(String.valueOf(file.getPath()) + File.separator + "metadata");
        FileOutputStream[] streams = new FileOutputStream[this.fNbChans];
        FileChannel[] channels = new FileChannel[this.fNbChans];
        try {
            int i = 0;
            while (i < this.fNbChans) {
                streams[i] = new FileOutputStream(new File(String.valueOf(file.getPath()) + File.separator + "channel" + i));
                channels[i] = streams[i].getChannel();
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        long evPerChan = this.fNbEvents / (long)this.fNbChans;
        long delta = (int)(this.fDuration / evPerChan);
        long offsetTime = 0L;
        Random rndLost = new Random(1337L);
        int chan = 0;
        while (chan < this.fNbChans) {
            int currentSpace = 0;
            ByteBuffer bb = ByteBuffer.allocate(65536);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            Random rnd = new Random(1337L);
            int rnd0 = rnd.nextInt(this.fProcesses.size());
            String prevComm = this.fProcesses.get(rnd0);
            int prevPID = rnd0 + chan * this.fProcesses.size();
            if (rnd0 == 0) {
                prevPID = 0;
            }
            int prevPrio = 0;
            int prevPos = -1;
            int discarded = 0;
            int discardedTotal = 0;
            int eventNb = 0;
            while ((long)eventNb < evPerChan) {
                long shrunkenTimestamp;
                if (56 > currentSpace) {
                    eventNb += discarded;
                }
                long ts = (long)eventNb * delta + delta / (long)(this.fNbChans + 1) * (long)chan;
                int pos = rnd.nextInt((int)((double)this.fProcesses.size() * 1.5));
                if (pos >= this.fProcesses.size()) {
                    pos = 0;
                }
                while (pos == prevPos) {
                    pos = rnd.nextInt((int)((double)this.fProcesses.size() * 1.5));
                    if (pos < this.fProcesses.size()) continue;
                    pos = 0;
                }
                String nextComm = this.fProcesses.get(pos);
                int nextPID = pos + this.fProcesses.size() * chan;
                if (pos == 0) {
                    nextPID = 0;
                }
                int nextPrio = 0;
                if (56 > currentSpace) {
                    int i = 0;
                    while (i < currentSpace) {
                        bb.put((byte)0);
                        ++i;
                    }
                    PacketWriter pw = new PacketWriter(bb);
                    long tsBegin = ts;
                    offsetTime = ts;
                    int eventCount = Math.min(72, (int)evPerChan - eventNb);
                    discarded = rndLost.nextInt(10 * this.fNbChans) == 0 ? rndLost.nextInt(72) : 0;
                    discarded = Math.min(discarded, (int)evPerChan - eventNb - eventCount);
                    long tsEnd = (long)(eventNb + eventCount + discarded) * delta;
                    pw.writeNewHeader(tsBegin, tsEnd, chan, eventCount, discardedTotal += discarded);
                    currentSpace = 4032;
                }
                EventWriter ew = new EventWriter(bb);
                int prev_state = rnd.nextInt(100);
                if (prev_state != 0) {
                    prev_state = 1;
                }
                if ((shrunkenTimestamp = ts - offsetTime) > 0xFFFFFFFL) {
                    throw new IllegalStateException("Invalid timestamp overflow:" + shrunkenTimestamp);
                }
                int clampedTs = (int)(ts & 0x7FFFFFFL);
                int evSize = ew.writeEvent(clampedTs, prevComm, prevPID, prevPrio, prev_state, nextComm, nextPID, nextPrio);
                currentSpace -= evSize;
                prevComm = nextComm;
                prevPID = nextPID;
                prevPrio = nextPrio;
                if (bb.position() > 63000) {
                    LttngTraceGenerator.writeToDisk(channels, chan, bb);
                }
                ++eventNb;
            }
            int i = 0;
            while (i < currentSpace) {
                bb.put((byte)0);
                ++i;
            }
            LttngTraceGenerator.writeToDisk(channels, chan, bb);
            try {
                streams[chan].close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++chan;
        }
        try {
            Throwable throwable = null;
            Object var13_14 = null;
            try (FileOutputStream fos = new FileOutputStream(metadataFile);){
                fos.write(this.metadata.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private static void deleteDirectory(File directory) {
        try {
            Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeToDisk(FileChannel[] channels, int chan, ByteBuffer bb) {
        try {
            bb.flip();
            channels[chan].write(bb);
            bb.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getMetadataUST() {
        String metadata = metadataKernel.replace("\"kernel\"", "\"ust\"");
        return metadata.replace("lttng-modules", "lttng-ust");
    }

    private class EventWriter {
        public static final int SIZE = 56;
        private final ByteBuffer data;

        public EventWriter(ByteBuffer bb) {
            this.data = bb;
        }

        public int writeEvent(int ts, String prev_comm, int prev_tid, int prev_prio, int prev_state, String next_comm, int next_tid, int next_prio) {
            byte[] bOut = new byte[16];
            byte[] bIn = new byte[16];
            byte[] temp = prev_comm.getBytes();
            int i = 0;
            while (i < Math.min(temp.length, 16)) {
                bOut[i] = temp[i];
                ++i;
            }
            temp = next_comm.getBytes();
            i = 0;
            while (i < Math.min(temp.length, 16)) {
                bIn[i] = temp[i];
                ++i;
            }
            int timestamp = ts << 5;
            this.data.putInt(timestamp);
            this.data.put(bOut);
            this.data.putInt(prev_tid);
            this.data.putInt(prev_prio);
            this.data.putInt(prev_state);
            this.data.put(bIn);
            this.data.putInt(next_tid);
            this.data.putInt(next_prio);
            return 56;
        }
    }

    private class PacketWriter {
        private static final int SIZE = 4096;
        private static final int HEADER_SIZE = 64;
        private static final int CONTENT_SIZE = 4032;
        private final ByteBuffer data;

        public PacketWriter(ByteBuffer bb) {
            this.data = bb;
        }

        public void writeNewHeader(long tsBegin, long tsEnd, int cpu, int eventCount, int discarded) {
            byte[] uuid = new byte[]{17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
            this.data.putInt(-1040441407);
            this.data.put(uuid);
            this.data.putInt(0);
            this.data.putLong(tsBegin);
            this.data.putLong(tsEnd);
            this.data.putLong((eventCount * 56 + 64) * 8);
            this.data.putLong(32768L);
            this.data.putInt(discarded);
            this.data.putInt(cpu);
        }
    }
}

