/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.interval.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.internal.statesystem.core.interval.json.TmfIntervalStrings;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class TmfIntervalSerializer
implements JsonSerializer<ITmfStateInterval> {
    public JsonElement serialize(ITmfStateInterval src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("start", (Number)src.getStartTime());
        jsonObject.addProperty("end", (Number)src.getEndTime());
        jsonObject.addProperty("quark", (Number)src.getAttribute());
        Object value = src.getValue();
        if (value == null) {
            jsonObject.addProperty("type", TmfIntervalStrings.NULL);
            return jsonObject;
        }
        if (value.getClass().isInstance(CustomStateValue.class)) {
            jsonObject.addProperty("type", CustomStateValue.class.getName());
        } else {
            jsonObject.addProperty("type", value.getClass().getName());
        }
        if (value instanceof CustomStateValue) {
            CustomStateValue customValue = (CustomStateValue)value;
            int size = customValue.getSerializedSize();
            ByteBuffer buffer = ByteBuffer.allocate(size);
            buffer.clear();
            ISafeByteBufferWriter sbbw = SafeByteBufferFactory.wrapWriter((ByteBuffer)buffer, (int)size);
            customValue.serialize(sbbw);
            byte[] serializedValue = buffer.array();
            jsonObject.addProperty("value", Base64.getEncoder().encodeToString(serializedValue));
        } else if (value instanceof Number) {
            Number number = (Number)value;
            jsonObject.addProperty("value", number);
        } else if (value instanceof String) {
            jsonObject.addProperty("value", (String)value);
        } else {
            jsonObject.addProperty("value", value.toString());
        }
        return jsonObject;
    }
}

