/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.Assert;

public final class CPPTemplateTypeArgument
implements ICPPTemplateArgument {
    private final IType fType;
    private final IType fOriginalType;

    public CPPTemplateTypeArgument(IType type) {
        this(SemanticUtil.getSimplifiedType(type), type);
    }

    public CPPTemplateTypeArgument(IType simplifiedType, IType originalType) {
        Assert.isNotNull((Object)simplifiedType);
        Assert.isNotNull((Object)originalType);
        this.fType = simplifiedType;
        this.fOriginalType = originalType;
    }

    @Override
    public boolean isTypeValue() {
        return true;
    }

    @Override
    public boolean isNonTypeValue() {
        return false;
    }

    @Override
    public IType getTypeValue() {
        return this.fType;
    }

    @Override
    public IType getOriginalTypeValue() {
        return this.fOriginalType;
    }

    @Override
    public ICPPEvaluation getNonTypeEvaluation() {
        return null;
    }

    @Override
    public IValue getNonTypeValue() {
        return null;
    }

    @Override
    public IType getTypeOfNonTypeValue() {
        return null;
    }

    @Override
    public boolean isPackExpansion() {
        return this.fType instanceof ICPPParameterPackType;
    }

    @Override
    public ICPPTemplateArgument getExpansionPattern() {
        IType t;
        if (this.fType instanceof ICPPParameterPackType && (t = ((ICPPParameterPackType)this.fType).getType()) != null) {
            return new CPPTemplateTypeArgument(t);
        }
        return null;
    }

    @Override
    public boolean isSameValue(ICPPTemplateArgument arg) {
        return this.fType.isSameType(arg.getTypeValue());
    }

    public String toString() {
        return this.fType.toString();
    }
}

