/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.HashMap;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecConstructorChain;

public class CPPConstructor
extends CPPMethod
implements ICPPConstructor {
    public CPPConstructor(ICPPASTFunctionDeclarator declarator) {
        super(declarator);
    }

    @Override
    public ICPPExecution getConstructorChainExecution() {
        return CPPConstructor.getConstructorChainExecution(this);
    }

    @Override
    public ICPPExecution getConstructorChainExecution(IASTNode point) {
        return this.getConstructorChainExecution();
    }

    private static ICPPEvaluation getMemberEvaluation(ICPPField member, ICPPASTConstructorChainInitializer chainInitializer, IASTNode point) {
        IASTInitializer initializer = chainInitializer.getInitializer();
        if (initializer instanceof ICPPASTInitializerClause) {
            return ((ICPPASTInitializerClause)((Object)initializer)).getEvaluation();
        }
        if (initializer instanceof ICPPASTConstructorInitializer) {
            IBinding constructor = CPPSemantics.findImplicitlyCalledConstructor(chainInitializer);
            if (constructor == null) {
                boolean usesBracedInitList = initializer instanceof ICPPASTInitializerList;
                return new EvalTypeId(member.getType(), point, usesBracedInitList, EvalConstructor.extractArguments(initializer));
            }
            if (constructor instanceof IProblemBinding) {
                return EvalFixed.INCOMPLETE;
            }
            return new EvalConstructor(member.getType(), (ICPPConstructor)constructor, EvalConstructor.extractArguments(initializer), point);
        }
        return null;
    }

    static ICPPExecution computeConstructorChainExecution(IASTNode def) {
        ICPPASTFunctionDefinition fnDef = CPPConstructor.getFunctionDefinition(def);
        if (fnDef != null) {
            ICPPASTConstructorChainInitializer[] ccInitializers = fnDef.getMemberInitializers();
            HashMap<IBinding, ICPPEvaluation> resultPairs = new HashMap<IBinding, ICPPEvaluation>();
            ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = ccInitializers;
            int n = ccInitializers.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTConstructorChainInitializer ccInitializer = iCPPASTConstructorChainInitializerArray[n2];
                IBinding member = ccInitializer.getMemberInitializerId().resolveBinding();
                if (member instanceof ICPPField) {
                    ICPPField fieldMember = (ICPPField)member;
                    ICPPEvaluation memberEval = CPPConstructor.getMemberEvaluation(fieldMember, ccInitializer, fnDef);
                    resultPairs.put(fieldMember, memberEval);
                } else if (member instanceof ICPPConstructor) {
                    ICPPConstructor ctorMember = (ICPPConstructor)member;
                    IASTInitializer initializer = ccInitializer.getInitializer();
                    if (initializer instanceof ICPPASTConstructorInitializer || initializer instanceof ICPPASTInitializerList) {
                        ICPPClassType baseClassType = (ICPPClassType)ctorMember.getOwner();
                        EvalConstructor memberEval = new EvalConstructor((IType)baseClassType, ctorMember, EvalConstructor.extractArguments(initializer, ctorMember), fnDef);
                        resultPairs.put(ctorMember, memberEval);
                    }
                }
                ++n2;
            }
            return new ExecConstructorChain(resultPairs);
        }
        return null;
    }

    static ICPPExecution getConstructorChainExecution(CPPFunction function) {
        if (!function.isConstexpr()) {
            return null;
        }
        return CPPConstructor.computeConstructorChainExecution(function.getDefinition());
    }
}

