/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.internal.runtime.CollectionTrustManager;

public class KeyStoreUtil {
    private static final String SYSTEM_PROPERTY_MERGE_TRUST = "eclipse.platform.mergeTrust";
    private final String os;

    public KeyStoreUtil(String os) {
        this.os = os;
    }

    public void setUpSslContext() throws GeneralSecurityException, IOException {
        if (!Boolean.getBoolean(SYSTEM_PROPERTY_MERGE_TRUST)) {
            return;
        }
        ArrayList<KeyStoreAndPassword> keyStores = new ArrayList<KeyStoreAndPassword>();
        keyStores.add(new KeyStoreAndPassword(null, null));
        if (System.getProperty("javax.net.ssl.trustStore", "").isEmpty()) {
            if ("macosx".equals(this.os)) {
                keyStores.add(this.createKeyStore("KeychainStore", "Apple"));
            } else if ("win32".equals(this.os)) {
                keyStores.add(this.createKeyStore("Windows-ROOT", null));
            }
        }
        ArrayList<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();
        for (KeyStoreAndPassword storeAndPassword : keyStores) {
            trustManagers.add(this.createX509TrustManager(storeAndPassword.keyStore()));
        }
        TrustManager[] tm = new TrustManager[]{new CollectionTrustManager(trustManagers)};
        KeyManager[] km = new KeyManager[]{};
        KeyStoreAndPassword keyStore = this.createKeyStoreFromSystemProperties();
        if (keyStore != null) {
            km = new KeyManager[]{this.createX509KeyManager(keyStore.keyStore(), keyStore.password())};
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        this.initSSLContext(sslContext, tm, km, null);
        SSLContext.setDefault(sslContext);
    }

    private KeyStoreAndPassword createKeyStore(String type, String provider) throws GeneralSecurityException, IOException {
        KeyStore keyStore = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
        keyStore.load(null, null);
        return new KeyStoreAndPassword(keyStore, null);
    }

    protected X509TrustManager createX509TrustManager(KeyStore keyStore) throws GeneralSecurityException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        return Arrays.stream(tmf.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst().orElse(null);
    }

    protected X509KeyManager createX509KeyManager(KeyStore keyStore, char[] password) throws GeneralSecurityException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password);
        return Arrays.stream(kmf.getKeyManagers()).filter(X509KeyManager.class::isInstance).map(X509KeyManager.class::cast).findFirst().orElse(null);
    }

    protected void initSSLContext(SSLContext context, TrustManager[] trustManagers, KeyManager[] keyManagers, SecureRandom random) throws KeyManagementException {
        context.init(keyManagers, trustManagers, random);
    }

    private KeyStoreAndPassword createKeyStoreFromSystemProperties() throws GeneralSecurityException, IOException {
        KeyStore ks;
        char[] passwd;
        String keyStoreType;
        String p11KeyStore;
        block14: {
            p11KeyStore = "PKCS11";
            String none = "NONE";
            String keyStore = System.getProperty("javax.net.ssl.keyStore", "");
            keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "");
            String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", "");
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
            if (keyStoreType.isEmpty()) {
                if (keyStore.isEmpty()) {
                    return null;
                }
                keyStoreType = KeyStore.getDefaultType();
            }
            if (p11KeyStore.equals(keyStoreType) && !none.equals(keyStore)) {
                throw new IllegalArgumentException("if keyStoreType is " + p11KeyStore + ", then keyStore must be " + none);
            }
            passwd = null;
            if (!keyStorePassword.isEmpty()) {
                passwd = keyStorePassword.toCharArray();
            }
            ks = null;
            ks = keyStoreProvider.isEmpty() ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, keyStoreProvider);
            if (!keyStore.isEmpty() && !none.equals(keyStore)) {
                Throwable throwable = null;
                Object var10_11 = null;
                try (FileInputStream is = new FileInputStream(keyStore);){
                    ks.load(is, passwd);
                    break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ks.load(null, passwd);
        }
        return new KeyStoreAndPassword(ks, p11KeyStore.equals(keyStoreType) ? null : passwd);
    }

    private record KeyStoreAndPassword(KeyStore keyStore, char[] password) {
    }
}

