/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.ExclusionInstance;
import org.eclipse.cdt.core.resources.RefreshExclusion;
import org.eclipse.cdt.core.resources.RefreshExclusionFactory;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class RefreshScopeManager {
    public static final String EXCLUSION_CLASS = "exclusionClass";
    public static final Object EXCLUSION_FACTORY = "exclusionFactory";
    public static final String EXTENSION_ID = "RefreshExclusionFactory";
    public static final String FACTORY_CLASS = "factoryClass";
    public static final String FILE_VALUE = "FILE";
    private static RefreshScopeManager fInstance;
    public static final String FOLDER_VALUE = "FOLDER";
    public static final String INSTANCE_CLASS = "instanceClass";
    public static final String OTHER_VALUE = "OTHER";
    public static final String PROJECT_VALUE = "PROJECT";
    public static final String REFRESH_SCOPE_STORAGE_NAME = "refreshScope";
    public static final String RESOURCE_ELEMENT_NAME = "resource";
    public static final String RESOURCE_TYPE_ATTRIBUTE_NAME = "resourceType";
    public static final String VERSION_ELEMENT_NAME = "version";
    public static final String VERSION_NUMBER_ATTRIBUTE_NAME = "versionNumber";
    public static final String WORKSPACE_PATH_ATTRIBUTE_NAME = "workspacePath";
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String CONFIGURATION_ELEMENT_NAME = "configurationName";
    private HashMap<String, RefreshExclusionFactory> fClassnameToExclusionFactoryMap = new HashMap();
    private boolean fIsLoaded = false;
    private boolean fIsLoading = false;
    private boolean fIsNewProject = false;
    private HashMap<IProject, HashMap<String, HashMap<IResource, List<RefreshExclusion>>>> fProjToConfToResToExcluMap;
    private int fVersion = 2;

    public static synchronized RefreshScopeManager getInstance() {
        if (fInstance == null) {
            fInstance = new RefreshScopeManager();
        }
        return fInstance;
    }

    private RefreshScopeManager() {
        this.loadExtensions();
        try {
            this.loadSettings();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 2 || event.getType() == 4) {
                    IProject project = event.getResource().getProject();
                    try {
                        if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
                            RefreshScopeManager.this.clearDataForProject(project);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    return;
                }
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta.getResource() instanceof IProject) {
                                    IProject project = (IProject)delta.getResource();
                                    if (delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0) {
                                        RefreshScopeManager.this.fIsLoading = true;
                                        RefreshScopeManager.this.loadSettings(ResourcesPlugin.getWorkspace().getRoot(), project);
                                        RefreshScopeManager.this.fIsLoading = false;
                                        return false;
                                    }
                                } else if (delta.getResource() instanceof IWorkspaceRoot) {
                                    return true;
                                }
                                return false;
                            }
                        });
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
        }, 7);
    }

    public synchronized void addExclusion(IProject project, String configName, IResource resource, RefreshExclusion exclusion) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        List<RefreshExclusion> exclusions = resourceMap.get(resource);
        if (exclusions == null) {
            exclusions = new LinkedList<RefreshExclusion>();
            resourceMap.put(resource, exclusions);
        }
        exclusions.add(exclusion);
    }

    public synchronized void addResourceToRefresh(IProject project, String configName, IResource resource) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        if (!resourceMap.containsKey(resource)) {
            LinkedList exclusions = new LinkedList();
            resourceMap.put(resource, exclusions);
        }
    }

    public synchronized void clearAllData() {
        this.getProjectToConfigurationToResourcesMap();
        this.fProjToConfToResToExcluMap.clear();
        this.fIsLoaded = false;
    }

    private synchronized void clearDataForProject(IProject project) {
        this.fProjToConfToResToExcluMap.remove(project);
    }

    public synchronized void clearExclusions(IProject project, String configName, IResource resource) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        List<RefreshExclusion> exclusions = resourceMap.get(resource);
        if (exclusions != null) {
            exclusions.clear();
        }
    }

    public synchronized void clearResourcesToRefresh(IProject project) {
        HashMap<String, HashMap<IResource, List<RefreshExclusion>>> configMap = this.getConfigurationToResourcesMap(project);
        HashMap<IResource, List<RefreshExclusion>> resourceMap = null;
        for (String configName : configMap.keySet()) {
            resourceMap = configMap.get(configName);
            resourceMap.clear();
        }
    }

    public synchronized void deleteResourceToRefresh(IProject project, String configName, IResource resource) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        if (resourceMap.containsKey(resource)) {
            resourceMap.remove(resource);
        }
    }

    public synchronized RefreshExclusion getExclusionForClassName(String className) {
        RefreshExclusionFactory factory = this.getFactoryForClassName(className);
        if (factory == null) {
            return null;
        }
        return factory.createNewExclusion();
    }

    public synchronized RefreshExclusionFactory getFactoryForClassName(String className) {
        RefreshExclusionFactory factory = this.fClassnameToExclusionFactoryMap.get(className);
        return factory;
    }

    public synchronized ExclusionInstance getInstanceForClassName(String className) {
        RefreshExclusionFactory factory = this.getFactoryForClassName(className);
        if (factory == null) {
            return null;
        }
        return factory.createNewExclusionInstance();
    }

    private HashMap<IResource, List<RefreshExclusion>> getResourcesToExclusionsMap(IProject project, String configName) {
        this.getProjectToConfigurationToResourcesMap();
        HashMap<String, HashMap<IResource, List<RefreshExclusion>>> configMap = this.getConfigurationToResourcesMap(project);
        HashMap<Object, List<RefreshExclusion>> resourceMap = configMap.get(configName);
        if (resourceMap == null) {
            resourceMap = new HashMap();
            if (!this.fIsLoading) {
                resourceMap.put((IResource)project, new LinkedList());
            }
            configMap.put(configName, resourceMap);
        }
        return resourceMap;
    }

    public synchronized HashMap<String, HashMap<IResource, List<RefreshExclusion>>> getConfigurationToResourcesMap(IProject project) {
        this.getProjectToConfigurationToResourcesMap();
        HashMap<String, HashMap<IResource, List<RefreshExclusion>>> configMap = this.fProjToConfToResToExcluMap.get(project);
        if (configMap == null) {
            this.initializeConfigMap(project);
            configMap = this.fProjToConfToResToExcluMap.get(project);
        }
        return configMap;
    }

    private HashMap<IProject, HashMap<String, HashMap<IResource, List<RefreshExclusion>>>> getProjectToConfigurationToResourcesMap() {
        if (this.fProjToConfToResToExcluMap == null) {
            this.fProjToConfToResToExcluMap = new HashMap();
        }
        return this.fProjToConfToResToExcluMap;
    }

    public IWorkspaceRunnable getRefreshRunnable(IProject project) {
        return this.getRefreshRunnable(project, null);
    }

    public IWorkspaceRunnable getRefreshRunnable(final IProject project, final String configName) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            private void refreshResources(String configName2, IResource resource, List<RefreshExclusion> exclusions, IProgressMonitor monitor) throws CoreException {
                if (resource instanceof IContainer) {
                    IContainer container = (IContainer)resource;
                    if (RefreshScopeManager.this.shouldResourceBeRefreshed(configName2, resource)) {
                        resource.refreshLocal(1, monitor);
                    }
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        this.refreshResources(configName2, child, exclusions, monitor);
                        ++n2;
                    }
                }
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                String name = configName;
                if (name == null) {
                    CProjectDescriptionManager descriptionManager = CProjectDescriptionManager.getInstance();
                    ICProjectDescription projectDescription = descriptionManager.getProjectDescription(project, false);
                    ICConfigurationDescription active_conf = projectDescription.getActiveConfiguration();
                    name = active_conf.getName();
                }
                List<IResource> resourcesToRefresh = RefreshScopeManager.this.getResourcesToRefresh(project, name);
                for (IResource resource : resourcesToRefresh) {
                    List<RefreshExclusion> exclusions = RefreshScopeManager.this.getExclusions(project, name, resource);
                    this.refreshResources(name, resource, exclusions, monitor);
                }
            }
        };
        return runnable;
    }

    public synchronized ISchedulingRule getRefreshSchedulingRule(IProject project, String configName) {
        return new MultiRule(this.getResourcesToRefresh(project, configName).toArray(new ISchedulingRule[0]));
    }

    public synchronized List<IResource> getResourcesToRefresh(IProject project, String configName) {
        this.getProjectToConfigurationToResourcesMap();
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        CProjectDescriptionManager descriptionManager = CProjectDescriptionManager.getInstance();
        ICProjectDescription projectDescription = descriptionManager.getProjectDescription(project, false);
        if (projectDescription == null && resourceMap.keySet().isEmpty()) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            resources.add((IResource)project);
            return resources;
        }
        return new ArrayList<IResource>(resourceMap.keySet());
    }

    public int getVersion() {
        return this.fVersion;
    }

    public synchronized void loadExtensions() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", EXTENSION_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (configElement.getName().equals(EXCLUSION_FACTORY)) {
                        String exclusionClassName = configElement.getAttribute(EXCLUSION_CLASS);
                        String factoryClassName = configElement.getAttribute(FACTORY_CLASS);
                        String instanceClassName = configElement.getAttribute(INSTANCE_CLASS);
                        if (factoryClassName != null) {
                            try {
                                Object execExt = configElement.createExecutableExtension(FACTORY_CLASS);
                                if (execExt instanceof RefreshExclusionFactory) {
                                    RefreshExclusionFactory exclusionFactory = (RefreshExclusionFactory)execExt;
                                    if (exclusionClassName != null) {
                                        this.fClassnameToExclusionFactoryMap.put(exclusionClassName, exclusionFactory);
                                    }
                                    if (instanceClassName != null) {
                                        this.fClassnameToExclusionFactoryMap.put(instanceClassName, exclusionFactory);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public synchronized void loadSettings() throws CoreException {
        if (!this.fIsLoaded && !this.fIsLoading) {
            this.fIsLoading = true;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = workspaceRoot.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                this.loadSettings(workspaceRoot, project);
                ++n2;
            }
            this.fIsLoaded = true;
            this.fIsLoading = false;
        }
    }

    public synchronized void loadSettings(IWorkspaceRoot workspaceRoot, IProject project) throws CoreException {
        if (project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
            CProjectDescriptionManager descriptionManager = CProjectDescriptionManager.getInstance();
            ICProjectDescription projectDescription = descriptionManager.getProjectDescription(project, false);
            if (projectDescription == null) {
                return;
            }
            ICStorageElement storageElement = projectDescription.getStorage(REFRESH_SCOPE_STORAGE_NAME, true);
            ICStorageElement[] children = storageElement.getChildren();
            String str = storageElement.getAttribute(VERSION_NUMBER_ATTRIBUTE_NAME);
            if (children.length != 0 && (str == null || str.equals("1"))) {
                ICConfigurationDescription[] cfgDescs;
                ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescs = projectDescription.getConfigurations();
                int n = cfgDescs.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription cfgDesc = iCConfigurationDescriptionArray[n2];
                    this.loadResourceData(workspaceRoot, project, cfgDesc.getName(), children);
                    ++n2;
                }
            } else {
                ICStorageElement[] iCStorageElementArray = children;
                int n = children.length;
                int n3 = 0;
                while (n3 < n) {
                    ICStorageElement child = iCStorageElementArray[n3];
                    if (child.getName().equals(CONFIGURATION_ELEMENT)) {
                        String configName = child.getAttribute(CONFIGURATION_ELEMENT_NAME);
                        this.loadResourceData(workspaceRoot, project, configName, child.getChildren());
                    }
                    ++n3;
                }
                if (children.length == 0) {
                    this.fIsNewProject = true;
                    this.getConfigurationToResourcesMap(project);
                    this.fIsNewProject = false;
                }
            }
        }
    }

    private void initializeConfigMap(IProject project) {
        HashMap configMap = new HashMap();
        CProjectDescriptionManager descriptionManager = CProjectDescriptionManager.getInstance();
        ICProjectDescription projectDescription = descriptionManager.getProjectDescription(project, false);
        if (projectDescription != null) {
            ICConfigurationDescription[] cfgDescs;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescs = projectDescription.getConfigurations();
            int n = cfgDescs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDesc = iCConfigurationDescriptionArray[n2];
                String configName = cfgDesc.getName();
                HashMap resourceMap = new HashMap();
                if (!this.fIsLoading || this.fIsNewProject) {
                    resourceMap.put(project, new LinkedList());
                }
                configMap.put(configName, resourceMap);
                ++n2;
            }
        }
        this.fProjToConfToResToExcluMap.put(project, configMap);
    }

    public synchronized void loadResourceData(IWorkspaceRoot workspaceRoot, IProject project, String configName, ICStorageElement[] children) {
        if (children.length == 0) {
            this.getResourcesToExclusionsMap(project, configName);
        } else {
            ICStorageElement[] iCStorageElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String resourcePath;
                ICStorageElement child = iCStorageElementArray[n2];
                if (child.getName().equals(RESOURCE_ELEMENT_NAME) && (resourcePath = child.getAttribute(WORKSPACE_PATH_ATTRIBUTE_NAME)) != null) {
                    String resourceTypeString = child.getAttribute(RESOURCE_TYPE_ATTRIBUTE_NAME);
                    if (resourceTypeString == null) {
                        resourceTypeString = OTHER_VALUE;
                    }
                    Object resource = null;
                    resource = resourceTypeString.equals(PROJECT_VALUE) ? workspaceRoot.getProject(resourcePath) : (resourceTypeString.equals(FILE_VALUE) ? workspaceRoot.getFile((IPath)new Path(resourcePath)) : (resourceTypeString.equals(FOLDER_VALUE) ? workspaceRoot.getFolder((IPath)new Path(resourcePath)) : workspaceRoot.findMember(resourcePath)));
                    if (resource != null) {
                        this.addResourceToRefresh(project, configName, (IResource)resource);
                        try {
                            List<RefreshExclusion> exclusions = RefreshExclusion.loadData(child, null, (IResource)resource, this);
                            for (RefreshExclusion exclusion : exclusions) {
                                this.addExclusion(project, configName, (IResource)resource, exclusion);
                            }
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public synchronized void persistSettings(ICProjectDescription projectDescription) throws CoreException {
        IProject project = projectDescription.getProject();
        if (!project.exists()) {
            return;
        }
        if (project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
            ICStorageElement storageElement = projectDescription.getStorage(REFRESH_SCOPE_STORAGE_NAME, true);
            storageElement.clear();
            storageElement.setAttribute(VERSION_NUMBER_ATTRIBUTE_NAME, Integer.toString(this.fVersion));
            HashMap<String, HashMap<IResource, List<RefreshExclusion>>> configMap = this.getConfigurationToResourcesMap(project);
            if (!configMap.isEmpty()) {
                for (String configName : configMap.keySet()) {
                    ICStorageElement configElement = storageElement.createChild(CONFIGURATION_ELEMENT);
                    configElement.setAttribute(CONFIGURATION_ELEMENT_NAME, configName);
                    HashMap<IResource, List<RefreshExclusion>> resourceMap = configMap.get(configName);
                    for (IResource resource : resourceMap.keySet()) {
                        this.persistDataResource(configElement, resource, resourceMap);
                    }
                }
            }
        }
    }

    public synchronized void persistDataResource(ICStorageElement storageElement, IResource resource, HashMap<IResource, List<RefreshExclusion>> resourceMap) {
        ICStorageElement resourceElement = storageElement.createChild(RESOURCE_ELEMENT_NAME);
        resourceElement.setAttribute(WORKSPACE_PATH_ATTRIBUTE_NAME, resource.getFullPath().toString());
        String resourceTypeString = null;
        resourceTypeString = resource instanceof IFile ? FILE_VALUE : (resource instanceof IFolder ? FOLDER_VALUE : (resource instanceof IProject ? PROJECT_VALUE : OTHER_VALUE));
        resourceElement.setAttribute(RESOURCE_TYPE_ATTRIBUTE_NAME, resourceTypeString);
        List<RefreshExclusion> exclusions = resourceMap.get(resource);
        if (exclusions != null) {
            for (RefreshExclusion exclusion : exclusions) {
                exclusion.persistData(resourceElement);
            }
        }
    }

    public synchronized void removeExclusion(IProject project, String configName, IResource resource, RefreshExclusion exclusion) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        List<RefreshExclusion> exclusions = resourceMap.get(resource);
        if (exclusions == null) {
            exclusions = new LinkedList<RefreshExclusion>();
            resourceMap.put(resource, exclusions);
        }
        exclusions.remove(exclusion);
    }

    public synchronized void setExclusions(IProject project, String configName, IResource resource, List<RefreshExclusion> newExclusions) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        LinkedList<RefreshExclusion> exclusions = new LinkedList<RefreshExclusion>(newExclusions);
        resourceMap.put(resource, exclusions);
    }

    public synchronized List<RefreshExclusion> getExclusions(IProject project, String configName, IResource resource) {
        HashMap<IResource, List<RefreshExclusion>> resourceMap = this.getResourcesToExclusionsMap(project, configName);
        List<RefreshExclusion> exclusions = resourceMap.get(resource);
        if (exclusions == null) {
            exclusions = new LinkedList<RefreshExclusion>();
            resourceMap.put(resource, exclusions);
        }
        return exclusions;
    }

    public synchronized void setResourcesToExclusionsMap(IProject project, String configName, HashMap<IResource, List<RefreshExclusion>> source_resourceMap) {
        HashMap<IResource, List<RefreshExclusion>> target_resourceMap = this.getResourcesToExclusionsMap(project, configName);
        target_resourceMap.clear();
        for (IResource source_resource : source_resourceMap.keySet()) {
            List<RefreshExclusion> source_exclusions = source_resourceMap.get(source_resource);
            LinkedList<RefreshExclusion> target_exclusions = new LinkedList<RefreshExclusion>();
            for (RefreshExclusion exclusion : source_exclusions) {
                target_exclusions.add(exclusion);
            }
            target_resourceMap.put(source_resource, target_exclusions);
        }
    }

    public synchronized boolean shouldResourceBeRefreshed(String configName, IResource resource) {
        IProject project = resource.getProject();
        List<IResource> resourcesToRefresh = this.getResourcesToRefresh(project, configName);
        boolean isInSomeTree = false;
        IResource topLevelResource = null;
        for (IResource resourceToRefresh : resourcesToRefresh) {
            IContainer container;
            if (resourceToRefresh.equals((Object)resource)) {
                isInSomeTree = true;
                topLevelResource = resource;
                break;
            }
            if (!(resourceToRefresh instanceof IContainer) || !(container = (IContainer)resourceToRefresh).getFullPath().isPrefixOf(resource.getFullPath())) continue;
            isInSomeTree = true;
            topLevelResource = resourceToRefresh;
            break;
        }
        if (!isInSomeTree) {
            return false;
        }
        boolean isExcluded = false;
        for (RefreshExclusion exclusion : this.getExclusions(project, configName, topLevelResource)) {
            if (!exclusion.testExclusionChain(resource)) continue;
            isExcluded = true;
            break;
        }
        return !isExcluded;
    }
}

