/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class RosMessageFlowSegment {
    private final long fStartTime;
    private final long fEndTime;
    private final SegmentType fType;
    private final String fNodeName;
    private final String fTopicName;
    private @Nullable RosMessageFlowSegment fPrevious = null;
    private final Collection<RosMessageFlowSegment> fNext = new ArrayList<RosMessageFlowSegment>();

    public RosMessageFlowSegment(long startTime, long endTime, SegmentType type, String nodeName, String topicName) {
        this(startTime, endTime, type, nodeName, topicName, null);
    }

    public RosMessageFlowSegment(long start, long end, SegmentType type, String nodeName, String topicName, RosMessageFlowSegment previous) {
        this.fStartTime = start;
        this.fEndTime = end;
        this.fType = type;
        this.fNodeName = nodeName;
        this.fTopicName = topicName;
        this.fPrevious = previous;
    }

    public void setPrevious(RosMessageFlowSegment previous) {
        this.fPrevious = previous;
    }

    public void addNext(RosMessageFlowSegment next) {
        this.fNext.add(next);
    }

    public @Nullable RosMessageFlowSegment getPrevious() {
        return this.fPrevious;
    }

    public boolean hasPrevious() {
        return this.fPrevious != null;
    }

    public Collection<RosMessageFlowSegment> getNext() {
        return this.fNext;
    }

    public boolean hasNext() {
        return !this.fNext.isEmpty();
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public SegmentType getType() {
        return this.fType;
    }

    public String getNodeName() {
        return this.fNodeName;
    }

    public String getTopicName() {
        return this.fTopicName;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fEndTime, this.fNext, this.fNodeName, this.fPrevious, this.fStartTime, this.fTopicName, this.fType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RosMessageFlowSegment)) {
            return false;
        }
        RosMessageFlowSegment other = (RosMessageFlowSegment)obj;
        return this.fEndTime == other.fEndTime && Objects.equals(this.fNext, other.fNext) && Objects.equals(this.fNodeName, other.fNodeName) && Objects.equals(this.fPrevious, other.fPrevious) && this.fStartTime == other.fStartTime && Objects.equals(this.fTopicName, other.fTopicName) && this.fType == other.fType;
    }

    public static enum SegmentType {
        SUB_QUEUE,
        SUB_CALLBACK,
        PUB_QUEUE,
        INVALID;

    }
}

