/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.trace;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class DatEvent {
    private static final int UFTRACE_MAGIC_NUMBER = 5;
    private static final long TYPE_MASK = 3L;
    private static final long MARKER_MASK = 4L;
    private static final long MAGIC_MASK = 56L;
    private static final long DEPTH_MASK = 65472L;
    private static final long ADDRESS_MASK = -65536L;
    private static final String[] TYPES = new String[]{"ENTRY", "EXIT", "EVENT", "LOST"};
    private final long fTime;
    private final String fType;
    private final int fDepth;
    private final long fAddress;
    private final int fTid;

    public static @Nullable DatEvent create(ByteBuffer bb, int tid, long offset) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long time = bb.getLong() + offset;
        long payload = bb.getLong();
        return DatEvent.create(time, payload, tid);
    }

    public static @Nullable DatEvent create(long nanoseconds, long payload, int tid) {
        String type = TYPES[(int)(payload & 3L)];
        if (type == null) {
            throw new IllegalStateException("Trace type cannot be null");
        }
        boolean moreData = (payload & 4L) == 4L;
        int magic = (int)((payload & 0x38L) >>> 3);
        int depth = (int)((payload & 0xFFC0L) >>> 6);
        long address = (payload & 0xFFFFFFFFFFFF0000L) >>> 16;
        if (magic != 5) {
            return null;
        }
        return new DatEvent(nanoseconds, type, depth, address, tid);
    }

    private DatEvent(long nanoseconds, String type, int depth, long address, int tid) {
        this.fTime = nanoseconds;
        this.fType = type;
        this.fDepth = depth;
        this.fAddress = address;
        this.fTid = tid;
    }

    public long getTime() {
        return this.fTime;
    }

    public String getType() {
        return this.fType;
    }

    public int getDepth() {
        return this.fDepth;
    }

    public long getAddress() {
        return this.fAddress;
    }

    public int getTid() {
        return this.fTid;
    }
}

