/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.IRosStateProviderInstantiator;
import org.eclipse.tracecompass.incubator.internal.ros.core.trace.layout.IRosEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public abstract class AbstractRosStateProvider
extends AbstractTmfStateProvider
implements IRosStateProviderInstantiator {
    public static final String TIMER_SCHEDULED = "scheduled";
    public static final String SUBSCRIBERS_LIST = "Subscribers";
    public static final String PUBLISHERS_LIST = "Publishers";
    public static final String CALLBACKS = "callbacks";
    public static final String SUBSCRIBER_MESSAGE_PROCESSING = "message processing";
    public static final String QUEUE = "queue";
    public static final String DROPS = "drops";
    public static final String TOPIC_PREFIX = "/";
    private static final int UNKNOWN = -1;
    private static final String UNKNOWN_NODE_NAME = "UNKNOWN_NODE";
    protected final IRosEventLayout fLayout;
    private Map<Long, Pair<String, String>> fNodesNamesPid = Maps.newHashMap();

    public AbstractRosStateProvider(ITmfTrace trace, @NonNull String id) {
        super(Objects.requireNonNull(trace), id);
        this.fLayout = IRosEventLayout.getDefault();
    }

    public abstract int getVersion();

    public @NonNull ITmfStateProvider getNewInstance() {
        return this.getNewRosStateProviderInstance(this.getClass(), this.getTrace());
    }

    protected static boolean considerEvent(@NonNull ITmfEvent event) {
        return event.getName().startsWith("roscpp:");
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        if (AbstractRosStateProvider.isEvent(event, this.fLayout.eventInitNode())) {
            this.putNodeName(event);
        }
    }

    protected static boolean isEvent(@NonNull ITmfEvent event, @NonNull String eventName) {
        return event.getName().equals(eventName);
    }

    protected static Object getField(@NonNull ITmfEvent event, @NonNull String fieldName) {
        Object val = event.getContent().getFieldValue(Object.class, new String[]{fieldName});
        if (val == null) {
            Activator.getInstance().logWarning("woops");
        }
        return val;
    }

    private void putNodeName(@NonNull ITmfEvent initEvent) {
        this.fNodesNamesPid.put((Long)AbstractRosStateProvider.getField(initEvent, this.fLayout.contextVpid()), (Pair<String, String>)new Pair((Object)((String)AbstractRosStateProvider.getField(initEvent, this.fLayout.contextProcname())), (Object)((String)AbstractRosStateProvider.getField(initEvent, this.fLayout.fieldNodeName()))));
    }

    protected String getNodeName(@NonNull ITmfEvent event) {
        @Nullable Pair<String, String> nodeNames = this.fNodesNamesPid.get(AbstractRosStateProvider.getField(event, this.fLayout.contextVpid()));
        if (nodeNames == null) {
            return UNKNOWN_NODE_NAME;
        }
        return (String)nodeNames.getFirst() + (String)nodeNames.getSecond();
    }

    protected static String extractGenericTaskName(String fullTaskName) {
        return StringUtils.substringBefore((String)fullTaskName, (String)"_");
    }

    protected @NonNull Long getTimerPeriodInNs(@NonNull ITmfEvent event) {
        Long sec = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPeriodSec()}).getValue();
        Long nSec = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPeriodNsec()}).getValue();
        return nSec + sec * (long)Math.pow(10.0, 9.0);
    }

    protected String getProcname(@NonNull ITmfEvent event) {
        return (String)event.getContent().getField(new String[]{this.fLayout.contextProcname()}).getValue();
    }

    protected Long getProcessId(@NonNull ITmfEvent event) {
        Long vpid = (Long)event.getContent().getField(new String[]{this.fLayout.contextVpid()}).getValue();
        if (vpid == null) {
            return -1L;
        }
        return vpid;
    }

    protected static String formatLongDecToHex(long dec) {
        return "0x" + Long.toHexString(dec);
    }
}

