/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.views.executor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.executor.Ros2ExecutorStateInstance;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class Ros2ExecutorPresentationProvider
extends TimeGraphPresentationProvider {
    private static final int NUM_COLORS = 3;
    private static final StateItem[] STATE_TABLE = new StateItem[3];
    protected final LoadingCache<NamedTimeEvent, Optional<String>> fTimeEventNames = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<NamedTimeEvent, Optional<String>>(){

        public Optional<String> load(NamedTimeEvent event) {
            return Optional.ofNullable(event.getLabel());
        }
    });

    static {
        Ros2ExecutorPresentationProvider.STATE_TABLE[Ros2ExecutorStateInstance.ExecutorState.GET_NEXT_READY.ordinal()] = new StateItem(new RGB(200, 0, 100), Ros2ExecutorStateInstance.ExecutorState.GET_NEXT_READY.toString());
        Ros2ExecutorPresentationProvider.STATE_TABLE[Ros2ExecutorStateInstance.ExecutorState.WAIT_FOR_WORK.ordinal()] = new StateItem(new RGB(200, 100, 0), Ros2ExecutorStateInstance.ExecutorState.WAIT_FOR_WORK.toString());
        STATE_TABLE[Ros2ExecutorStateInstance.ExecutorState.WAIT_FOR_WORK.ordinal()].getStyleMap().put("height", Float.valueOf(0.5f));
        Ros2ExecutorPresentationProvider.STATE_TABLE[Ros2ExecutorStateInstance.ExecutorState.EXECUTE.ordinal()] = new StateItem(new RGB(0, 200, 0), Ros2ExecutorStateInstance.ExecutorState.EXECUTE.toString());
    }

    public Ros2ExecutorPresentationProvider() {
        super("");
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof NamedTimeEvent) {
            NamedTimeEvent namedEvent = (NamedTimeEvent)event;
            Ros2ExecutorStateInstance.ExecutorState executorState = (Ros2ExecutorStateInstance.ExecutorState)namedEvent.getMetadata().get((Object)"state").iterator().next();
            return executorState.ordinal();
        }
        return -1;
    }

    public @Nullable String getEventName(ITimeEvent event) {
        return null;
    }

    public String getStateTypeName(ITimeGraphEntry entry) {
        if (!(entry instanceof TimeGraphEntry)) {
            return null;
        }
        TimeGraphEntry timeGraphEntry = (TimeGraphEntry)entry;
        TimeGraphEntry parentTimeGraphEntry = timeGraphEntry.getParent();
        if (parentTimeGraphEntry == null) {
            return null;
        }
        TimeGraphEntry grandParentTimeGraphEntry = parentTimeGraphEntry.getParent();
        if (grandParentTimeGraphEntry == null) {
            return "Trace";
        }
        TimeGraphEntry greatGrandParentTimeGraphEntry = grandParentTimeGraphEntry.getParent();
        if (greatGrandParentTimeGraphEntry == null) {
            return "PID";
        }
        return "TID";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        @NonNull @NonNull Multimap metadata = event.getMetadata();
        Ros2ExecutorStateInstance.ExecutorState executorState = (Ros2ExecutorStateInstance.ExecutorState)metadata.get((Object)"state").iterator().next();
        builder.put((Object)"State", (Object)executorState.toString());
        Long handle = (Long)metadata.get((Object)"handle").iterator().next();
        builder.put((Object)"Handle", handle != 0L ? "0x" + Long.toHexString(handle) : "-");
        return builder.build();
    }
}

