/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.symbol;

import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.internal.callstack.core.symbol.ResolvableSymbol;
import org.eclipse.tracecompass.incubator.internal.callstack.core.symbol.StringSymbol;

public final class CallStackSymbolFactory {
    private CallStackSymbolFactory() {
    }

    public static ICallStackSymbol createSymbol(Object symbol, ICallStackElement element, long timestamp) {
        if (symbol instanceof Long || symbol instanceof Integer) {
            long longAddress = (Long)symbol;
            return new ResolvableSymbol(longAddress, element.getSymbolKeyAt(timestamp), timestamp);
        }
        if (symbol instanceof String) {
            try {
                long longAddress = Long.parseUnsignedLong((String)symbol, 16);
                return new ResolvableSymbol(longAddress, element.getSymbolKeyAt(timestamp), timestamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new StringSymbol(symbol);
    }
}

