/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.AttributeUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPComputableFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPFunction
extends PlatformObject
implements ICPPFunction,
ICPPInternalFunction {
    public static final ICPPFunction UNINITIALIZED_FUNCTION = new CPPFunction(null){

        @Override
        public String toString() {
            return "UNINITIALIZED_FUNCTION";
        }
    };
    protected IASTDeclarator[] declarations;
    protected ICPPASTFunctionDeclarator definition;
    protected ICPPFunctionType declaredType;
    protected ICPPFunctionType type;
    private static final int FULLY_RESOLVED = 1;
    private static final int RESOLUTION_IN_PROGRESS = 2;
    private int bits;

    public CPPFunction(IASTDeclarator declarator) {
        if (declarator != null) {
            IASTNode parent = ASTQueries.findOutermostDeclarator(declarator).getParent();
            if (parent instanceof IASTFunctionDefinition) {
                if (declarator instanceof ICPPASTFunctionDeclarator) {
                    this.definition = (ICPPASTFunctionDeclarator)declarator;
                }
            } else {
                this.declarations = new IASTDeclarator[]{declarator};
            }
            IASTName name = this.getASTName();
            name.setBinding(this);
        }
    }

    private void resolveAllDeclarations() {
        if ((this.bits & 3) == 0) {
            this.bits |= 2;
            IASTTranslationUnit tu = null;
            if (this.definition != null) {
                tu = this.definition.getTranslationUnit();
            } else if (this.declarations != null) {
                tu = this.declarations[0].getTranslationUnit();
            } else {
                IScope scope = this.getScope();
                IASTNode node = ASTInternal.getPhysicalNodeOfScope(scope);
                if (node != null) {
                    tu = node.getTranslationUnit();
                }
            }
            if (tu != null) {
                CPPVisitor.getDeclarations(tu, this);
            }
            this.declarations = ArrayUtil.trim(IASTDeclarator.class, this.declarations);
            this.bits |= 1;
            this.bits &= 0xFFFFFFFD;
        }
    }

    public IASTDeclarator[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public ICPPASTFunctionDeclarator getDefinition() {
        return this.definition;
    }

    @Override
    public final void addDefinition(IASTNode node) {
        IASTDeclarator dtor = this.extractRelevantDtor(node);
        if (dtor instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)dtor;
            this.updateFunctionParameterBindings(fdtor);
            this.definition = fdtor;
        }
    }

    @Override
    public final void addDeclaration(IASTNode node) {
        IASTDeclarator dtor = this.extractRelevantDtor(node);
        if (dtor == null) {
            return;
        }
        if (dtor instanceof ICPPASTFunctionDeclarator) {
            this.updateFunctionParameterBindings((ICPPASTFunctionDeclarator)dtor);
        }
        this.declarations = this.declarations == null || this.declarations.length == 0 ? new IASTDeclarator[]{dtor} : (((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? ArrayUtil.prepend(this.declarations, dtor) : ArrayUtil.append(this.declarations, dtor));
    }

    private IASTDeclarator extractRelevantDtor(IASTNode node) {
        while (node instanceof IASTName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        return ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)node);
    }

    @Override
    public ICPPParameter[] getParameters() {
        ICPPASTFunctionDeclarator declarator = this.getDefinition();
        IASTDeclarator[] dtors = this.getDeclarations();
        if (dtors != null) {
            int defaultValuePosition = -1;
            IASTDeclarator[] iASTDeclaratorArray = dtors;
            int n = dtors.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator dtor = iASTDeclaratorArray[n2];
                if (dtor instanceof ICPPASTFunctionDeclarator) {
                    if (declarator == null) {
                        declarator = (ICPPASTFunctionDeclarator)dtor;
                    } else {
                        int pos;
                        ICPPASTFunctionDeclarator contender = (ICPPASTFunctionDeclarator)dtor;
                        if (defaultValuePosition < 0) {
                            defaultValuePosition = CPPFunction.findFirstDefaultValue(declarator.getParameters());
                        }
                        if ((pos = CPPFunction.findFirstDefaultValue(contender.getParameters())) < defaultValuePosition) {
                            declarator = contender;
                            defaultValuePosition = pos;
                        }
                    }
                }
                ++n2;
            }
        }
        if (declarator == null) {
            return CPPBuiltinParameter.createParameterList(this.getType());
        }
        ICPPASTParameterDeclaration[] params = declarator.getParameters();
        int size = params.length;
        ICPPParameter[] result = new ICPPParameter[size];
        if (size > 0) {
            int i = 0;
            while (i < size) {
                ICPPASTParameterDeclaration param = params[i];
                IASTName name = this.getParamName(param);
                IBinding binding = name.resolveBinding();
                result[i] = binding instanceof ICPPParameter ? (ICPPParameter)binding : new CPPParameter.CPPParameterProblem(param, 5, name.toCharArray());
                ++i;
            }
            if (result.length == 1 && SemanticUtil.isVoidType(result[0].getType())) {
                return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
            }
        }
        return result;
    }

    static int findFirstDefaultValue(ICPPASTParameterDeclaration[] parameters) {
        int i = parameters.length;
        while (--i >= 0) {
            if (parameters[i].getDeclarator().getInitializer() != null) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public IScope getFunctionScope() {
        this.resolveAllDeclarations();
        if (this.definition != null) {
            return this.definition.getFunctionScope();
        }
        IASTDeclarator[] iASTDeclaratorArray = this.declarations;
        int n = this.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator dtor = iASTDeclaratorArray[n2];
            if (dtor instanceof ICPPASTFunctionDeclarator) {
                return ((ICPPASTFunctionDeclarator)dtor).getFunctionScope();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getASTName().toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.getASTName().getSimpleID();
    }

    protected IASTName getASTName() {
        IASTDeclarator dtor = this.definition != null ? this.definition : this.declarations[0];
        dtor = ASTQueries.findInnermostDeclarator(dtor);
        return dtor.getName().getLastName();
    }

    @Override
    public IScope getScope() {
        ICPPASTDeclSpecifier declSpec;
        IASTName n = this.getASTName();
        IScope scope = CPPVisitor.getContainingScope(n);
        if (scope instanceof ICPPClassScope && (declSpec = this.getDeclSpecifier()) != null && declSpec.isFriend()) {
            try {
                while (scope instanceof ICPPClassScope) {
                    scope = scope.getParent();
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return scope;
    }

    private ICPPASTDeclSpecifier getDeclSpecifier() {
        if (this.definition != null) {
            IASTNode node = ASTQueries.findOutermostDeclarator(this.definition).getParent();
            IASTFunctionDefinition def = (IASTFunctionDefinition)node;
            return (ICPPASTDeclSpecifier)def.getDeclSpecifier();
        }
        if (this.declarations != null && this.declarations.length != 0) {
            IASTNode node = ASTQueries.findOutermostDeclarator(this.declarations[0]).getParent();
            IASTSimpleDeclaration decl = (IASTSimpleDeclaration)node;
            return (ICPPASTDeclSpecifier)decl.getDeclSpecifier();
        }
        return null;
    }

    public static ICPPFunctionType toFunctionType(IType type) {
        if (type instanceof ICPPFunctionType) {
            return (ICPPFunctionType)type;
        }
        if ((type = SemanticUtil.getNestedType(type, 1)) instanceof ICPPFunctionType) {
            return (ICPPFunctionType)type;
        }
        if (type instanceof ISemanticProblem) {
            return new ProblemFunctionType(((ISemanticProblem)((Object)type)).getID());
        }
        return new ProblemFunctionType(10001);
    }

    @Override
    public ICPPFunctionType getDeclaredType() {
        if (this.declaredType == null) {
            IType t = CPPVisitor.createType(this.definition != null ? this.definition : this.declarations[0], 0);
            this.declaredType = CPPFunction.toFunctionType(t);
        }
        return this.declaredType;
    }

    @Override
    public ICPPFunctionType getType() {
        if (this.type == null) {
            IType t = CPPVisitor.createType(this.definition != null ? this.definition : this.declarations[0]);
            if (t == ProblemType.NO_NAME) {
                this.findDefinition();
                if (this.definition != null) {
                    t = CPPVisitor.createType(this.definition);
                }
            }
            this.type = CPPFunction.toFunctionType(t);
        }
        return this.type;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IBinding resolveParameter(CPPParameter param) {
        pos = param.getParameterPosition();
        tdeclLen = this.declarations == null ? 0 : this.declarations.length;
        i = -1;
        while (i < tdeclLen) {
            block6: {
                block5: {
                    if (i != -1) break block5;
                    tdecl = this.definition;
                    if (tdecl != null) ** GOTO lbl16
                    break block6;
                }
                dtor = this.declarations[i];
                if (!(dtor instanceof ICPPASTFunctionDeclarator)) {
                    if (dtor == null) {
                        break;
                    }
                } else {
                    tdecl = (ICPPASTFunctionDeclarator)dtor;
lbl16:
                    // 2 sources

                    if (pos < (params = tdecl.getParameters()).length) {
                        oName = this.getParamName(params[pos]);
                        return oName.resolvePreBinding();
                    }
                }
            }
            ++i;
        }
        return param;
    }

    private IASTName getParamName(IASTParameterDeclaration paramDecl) {
        return ASTQueries.findInnermostDeclarator(paramDecl.getDeclarator()).getName();
    }

    /*
     * Unable to fully structure code
     */
    protected final void updateFunctionParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        updateParams = fdtor.getParameters();
        k = 0;
        tdeclLen = this.declarations == null ? 0 : this.declarations.length;
        i = -1;
        while (i < tdeclLen && k < updateParams.length) {
            block6: {
                block5: {
                    if (i != -1) break block5;
                    tdecl = this.definition;
                    if (tdecl != null) ** GOTO lbl17
                    break block6;
                }
                dtor = this.declarations[i];
                if (!(dtor instanceof ICPPASTFunctionDeclarator)) {
                    if (dtor == null) {
                        break;
                    }
                } else {
                    tdecl = (ICPPASTFunctionDeclarator)dtor;
lbl17:
                    // 2 sources

                    params = tdecl.getParameters();
                    end = Math.min(params.length, updateParams.length);
                    while (k < end) {
                        oName = this.getParamName(params[k]);
                        b = oName.resolvePreBinding();
                        n = this.getParamName(updateParams[k]);
                        n.setBinding(b);
                        ASTInternal.addDeclaration(b, n);
                        ++k;
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public final boolean isStatic() {
        return this.isStatic(true);
    }

    @Override
    public boolean isStatic(boolean resolveAll) {
        if (resolveAll && (this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        return CPPFunction.hasStorageClass(this, 3);
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public static boolean hasStorageClass(ICPPInternalFunction function, int storage) {
        IASTDeclarator dtor = (IASTDeclarator)function.getDefinition();
        IASTNode[] ds = function.getDeclarations();
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = (IASTDeclarator)ds[i]) != null);
        return false;
    }

    public static ICPPASTFunctionDefinition getFunctionDefinition(IASTNode def) {
        while (def != null && !(def instanceof IASTDeclaration)) {
            def = def.getParent();
        }
        if (def instanceof ICPPASTFunctionDefinition) {
            return (ICPPASTFunctionDefinition)def;
        }
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isInline() {
        IASTDeclarator dtor = this.getDefinition();
        IASTDeclarator[] ds = this.getDeclarations();
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || !declSpec.isInline()) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = ds[i]) != null);
        return false;
    }

    @Override
    public boolean isExternC() {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTDeclarator[] ds = this.getDeclarations();
        if (ds != null) {
            IASTDeclarator[] iASTDeclaratorArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator element = iASTDeclaratorArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isExtern() {
        return CPPFunction.hasStorageClass(this, 2);
    }

    @Override
    public boolean isAuto() {
        return CPPFunction.hasStorageClass(this, 4);
    }

    @Override
    public boolean isConstexpr() {
        ICPPASTDeclSpecifier declSpec = this.getDeclSpecifier();
        if (declSpec == null) {
            return false;
        }
        return declSpec.isConstexpr();
    }

    @Override
    public boolean isDeleted() {
        return CPPFunction.isDeletedDefinition(this.getDefinition());
    }

    static boolean isDeletedDefinition(IASTNode def) {
        ICPPASTFunctionDefinition functionDefinition = CPPFunction.getFunctionDefinition(def);
        if (functionDefinition != null) {
            return functionDefinition.isDeleted();
        }
        return false;
    }

    @Override
    public boolean isRegister() {
        return CPPFunction.hasStorageClass(this, 5);
    }

    @Override
    public boolean takesVarArgs() {
        ICPPASTFunctionDeclarator dtor = this.getPreferredDtor();
        return dtor != null ? dtor.takesVarArgs() : false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeStringAndQualifiers(t) : "()");
        return result.toString();
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findNameOwner(this.getASTName(), false);
    }

    @Override
    public IType[] getExceptionSpecification() {
        ICPPASTFunctionDeclarator declarator = this.getPreferredDtor();
        if (declarator != null) {
            IASTTypeId[] astTypeIds = declarator.getExceptionSpecification();
            if (astTypeIds.equals(ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION)) {
                return null;
            }
            if (astTypeIds.equals(IASTTypeId.EMPTY_TYPEID_ARRAY)) {
                return IType.EMPTY_TYPE_ARRAY;
            }
            IType[] typeIds = new IType[astTypeIds.length];
            int i = 0;
            while (i < astTypeIds.length) {
                typeIds[i] = CPPVisitor.createType(astTypeIds[i]);
                ++i;
            }
            return typeIds;
        }
        return null;
    }

    protected ICPPASTFunctionDeclarator getPreferredDtor() {
        ICPPASTFunctionDeclarator dtor = this.getDefinition();
        if (dtor != null) {
            return dtor;
        }
        IASTDeclarator[] dtors = this.getDeclarations();
        if (dtors != null) {
            IASTDeclarator[] iASTDeclaratorArray = dtors;
            int n = dtors.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator declarator = iASTDeclaratorArray[n2];
                if (declarator instanceof ICPPASTFunctionDeclarator) {
                    return (ICPPASTFunctionDeclarator)declarator;
                }
                ++n2;
            }
        }
        return dtor;
    }

    @Override
    public int getRequiredArgumentCount() {
        return CPPFunction.getRequiredArgumentCount(this.getParameters());
    }

    public static int getRequiredArgumentCount(ICPPParameter[] pars) {
        int result = pars.length;
        int i = pars.length;
        while (--i >= 0) {
            ICPPParameter p = pars[i];
            if (!p.hasDefaultValue() && !p.isParameterPack()) continue;
            --result;
        }
        return result;
    }

    @Override
    public boolean hasParameterPack() {
        return CPPFunction.hasParameterPack(this.getParameters());
    }

    public static boolean hasParameterPack(ICPPParameter[] pars) {
        return pars.length > 0 && pars[pars.length - 1].isParameterPack();
    }

    @Override
    public boolean isNoReturn() {
        return CPPFunction.isNoReturn(this.getPreferredDtor());
    }

    public static boolean isNoReturn(ICPPASTFunctionDeclarator dtor) {
        if (dtor == null) {
            return false;
        }
        if (AttributeUtil.hasNoreturnAttribute(dtor)) {
            return true;
        }
        IASTNode parent = dtor.getParent();
        if (parent instanceof IASTAttributeOwner) {
            return AttributeUtil.hasNoreturnAttribute((IASTAttributeOwner)parent);
        }
        return false;
    }

    public static ICPPExecution getFunctionBodyExecution(ICPPFunction function) {
        if (function instanceof ICPPComputableFunction) {
            return ((ICPPComputableFunction)((Object)function)).getFunctionBodyExecution();
        }
        return null;
    }

    @Override
    public ICPPExecution getFunctionBodyExecution() {
        IASTTranslationUnit tu;
        if (!this.isConstexpr()) {
            return null;
        }
        if (this.getDefinition() == null && this.declarations != null && this.declarations[0] != null && (tu = this.declarations[0].getTranslationUnit()) != null) {
            tu.getDefinitionsInAST(this);
        }
        return CPPFunction.computeFunctionBodyExecution(this.getDefinition());
    }

    public static ICPPExecution computeFunctionBodyExecution(IASTNode def) {
        ICPPASTFunctionDefinition fnDef = CPPFunction.getFunctionDefinition(def);
        if (fnDef != null) {
            ((ASTNode)((Object)fnDef)).resolvePendingAmbiguities();
            if (fnDef.getBody() instanceof CPPASTCompoundStatement) {
                CPPASTCompoundStatement body = (CPPASTCompoundStatement)fnDef.getBody();
                return body.getExecution();
            }
        }
        return null;
    }

    private void findDefinition() {
        if (this.definition != null) {
            return;
        }
        IASTName[] definitions = this.declarations[0].getTranslationUnit().getDefinitionsInAST(this);
        if (definitions.length != 0) {
            this.addDefinition(definitions[0]);
        }
    }

    public static class CPPFunctionProblem
    extends ProblemBinding
    implements ICPPFunction {
        public CPPFunctionProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public CPPFunctionProblem(IASTName name, int id) {
            super(name, id);
        }

        @Override
        public IScope getFunctionScope() {
            return null;
        }

        @Override
        public boolean isNoReturn() {
            return false;
        }

        @Override
        public ICPPFunctionType getType() {
            return null;
        }

        @Override
        public ICPPFunctionType getDeclaredType() {
            return null;
        }

        @Override
        public ICPPParameter[] getParameters() {
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }

        @Override
        public int getRequiredArgumentCount() {
            return 0;
        }
    }
}

