/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.preferences;

import java.util.Set;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class BreakpointPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PLUGIN_ID = "org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage";
    private BooleanFieldEditor context_enabled;
    private ComboFieldEditor context_expression;
    private BooleanFieldEditor offset_enabled;
    private IntegerFieldEditor offset_limit;

    public BreakpointPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.TCFBreakpointPreferencesDescription);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        if (source == this.context_enabled) {
            this.context_expression.setEnabled(this.context_enabled.getBooleanValue(), this.getFieldEditorParent());
        }
        if (source == this.offset_enabled) {
            this.offset_limit.setEnabled(this.offset_enabled.getBooleanValue(), this.getFieldEditorParent());
        }
    }

    public void createFieldEditors() {
        this.context_enabled = new BooleanFieldEditor("org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.setDefaultTriggerScopeEnabled", Messages.TCFBreakpointPreferencesEnableDefaultTriggerScope, this.getFieldEditorParent());
        this.addField((FieldEditor)this.context_enabled);
        String[] expressions = this.getTriggerExpressions();
        this.context_expression = new ComboFieldEditor("org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.defaultTriggerExpression", Messages.TCFBreakpointPreferencesTriggerScopeExpression, this.joinToArray2D(expressions, expressions), this.getFieldEditorParent());
        this.addField((FieldEditor)this.context_expression);
        this.offset_enabled = new BooleanFieldEditor("org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.lineOffsetLimitEnabled", Messages.TCFBreakpointPreferencesEnableLineOffsetLimit, this.getFieldEditorParent());
        this.addField((FieldEditor)this.offset_enabled);
        this.offset_limit = new IntegerFieldEditor("org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.lineOffsetLimit", Messages.TCFBreakpointPreferencesLineOffsetLimit, this.getFieldEditorParent());
        this.addField((FieldEditor)this.offset_limit);
        if (!this.checkTCFToggleBreakpointAdapter()) {
            this.context_enabled.setEnabled(false, this.getFieldEditorParent());
            this.context_expression.setEnabled(false, this.getFieldEditorParent());
            this.offset_enabled.setEnabled(false, this.getFieldEditorParent());
            this.offset_limit.setEnabled(false, this.getFieldEditorParent());
            this.setMessage(Messages.TCFBreakpointPrefrencesError, 2);
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    protected void checkState() {
        this.context_expression.setEnabled(this.context_enabled.getBooleanValue(), this.getFieldEditorParent());
        this.offset_limit.setEnabled(this.offset_enabled.getBooleanValue(), this.getFieldEditorParent());
        super.checkState();
    }

    public void init(IWorkbench workbench) {
    }

    private String[] getTriggerExpressions() {
        IDialogSettings dialogSettings = this.getBreakpointScopeDialogSettings();
        if (dialogSettings == null) {
            return new String[0];
        }
        String[] returnList = null;
        String[] expressionList = null;
        int index = 0;
        expressionList = dialogSettings.getArray(Messages.TCFThreadFilterQueryExpressionStore);
        if (expressionList != null) {
            index = 0;
            while (index < expressionList.length) {
                String member = expressionList[index];
                if (member == null || member.length() == 0) break;
                ++index;
            }
        }
        returnList = new String[index + 1];
        returnList[0] = "";
        int loop = 0;
        while (loop < index) {
            returnList[loop + 1] = expressionList[loop];
            ++loop;
        }
        return returnList;
    }

    private IDialogSettings getBreakpointScopeDialogSettings() {
        String component = "org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFThreadFilterEditor";
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        return settings.getSection(component);
    }

    private String[][] joinToArray2D(String[] labels, String[] values) {
        String[][] array2d = new String[labels.length][];
        int i = 0;
        while (i < labels.length) {
            array2d[i] = new String[2];
            array2d[i][0] = labels[i];
            array2d[i][1] = values[i];
            ++i;
        }
        return array2d;
    }

    private boolean checkTCFToggleBreakpointAdapter() {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part == null) {
            part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        }
        if (part != null) {
            ISelection selection = part.getSite().getSelectionProvider().getSelection();
            Set enablers = DebugUITools.getToggleBreakpointsTargetManager().getEnabledToggleBreakpointsTargetIDs((IWorkbenchPart)part, selection);
            if (enablers != null && !enablers.contains("org.eclipse.tcf.debug.toggleTCFBreakpoint")) {
                return true;
            }
            String preferred = DebugUITools.getToggleBreakpointsTargetManager().getPreferredToggleBreakpointsTargetID((IWorkbenchPart)part, selection);
            if (preferred != null && !preferred.equals("org.eclipse.tcf.debug.toggleTCFBreakpoint")) {
                return false;
            }
        }
        return true;
    }
}

