/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.rename.RenameFolderProcessor;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameProcessorTestCase0026915
extends AbstractRefactoringTest {
    private IProject project1;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        TestUtils.createFile((IFolder)folder, (String)"test1.php", (String)"<?php class TestRenameClass{}?>");
        TestUtils.waitForIndexer();
    }

    @Test
    public void testRename() {
        RenameFolderProcessor processor = new RenameFolderProcessor((IContainer)this.project1.getFolder("src"));
        processor.setNewElementName("src1");
        processor.setUpdateRefernces(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IFolder folder = this.project1.getFolder("src1");
        Assert.assertTrue((boolean)folder.exists());
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project1);
        FileUtils.isInBuildpath(folder.getFullPath(), scriptProject, 3);
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

