/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.launcher.IProfilerLaunchSettingsSection;

public class ProfilerLaunchSettingsSectionRegistry {
    private static List<Entry> entries;
    private static final String PROP_ID = "id";
    private static final String PROP_OVERRIDES = "overrides";
    private static final String PROP_PROFILER_ID = "profilerId";
    private static final String PROP_LAUNCH_TYPE_ID = "launchTypeId";
    private static final String PROP_SECTION = "section";
    public static final String EXTENSION_POINT_ID;
    private static ProfilerLaunchSettingsSectionRegistry instance;

    static {
        EXTENSION_POINT_ID = ProfilerUiPlugin.getDefault().getBundle().getSymbolicName() + ".phpProfilerLaunchSettingsSections";
    }

    private static final List<Entry> getEntries() {
        if (entries == null) {
            entries = ProfilerLaunchSettingsSectionRegistry.getDefault().readFromExtensionPoint();
        }
        return entries;
    }

    public static final IProfilerLaunchSettingsSection getSection(String profilerId, String launchTypeId) {
        for (Entry entry : ProfilerLaunchSettingsSectionRegistry.getEntries()) {
            if (!entry.profilerId.equals(profilerId) || !entry.launchTypeId.equals(launchTypeId)) continue;
            IProfilerLaunchSettingsSection settingsSection = null;
            try {
                settingsSection = (IProfilerLaunchSettingsSection)ProfilerLaunchSettingsSectionRegistry.createInstance(entry.element, PROP_SECTION, IProfilerLaunchSettingsSection.class);
            }
            catch (CoreException e) {
                ProfilerUiPlugin.log(e);
            }
            return settingsSection;
        }
        return null;
    }

    private static ProfilerLaunchSettingsSectionRegistry getDefault() {
        if (instance == null) {
            instance = new ProfilerLaunchSettingsSectionRegistry();
        }
        return instance;
    }

    private List<Entry> readFromExtensionPoint() {
        IConfigurationElement[] configurationElements;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(PROP_ID);
            String overridenSectionId = element.getAttribute(PROP_OVERRIDES);
            String profilerId = element.getAttribute(PROP_PROFILER_ID);
            String launchTypeId = element.getAttribute(PROP_LAUNCH_TYPE_ID);
            entries.add(new Entry(element, id, overridenSectionId, profilerId, launchTypeId));
            ++n2;
        }
        return this.filterEntries(entries);
    }

    private static Object createInstance(IConfigurationElement element, String propertyName, Class instanceClass) throws CoreException {
        Object object = element.createExecutableExtension(propertyName);
        if (!instanceClass.isAssignableFrom(object.getClass())) {
            String message = String.format("Invalid typecast for %s", element.getAttribute(propertyName));
            Status status = new Status(4, ProfilerUiPlugin.getDefault().getBundle().getSymbolicName(), message);
            throw new CoreException((IStatus)status);
        }
        return object;
    }

    private List<Entry> filterEntries(List<Entry> entries) {
        ArrayList<Entry> topHierarchyEntries = new ArrayList<Entry>();
        for (Entry entryToCheck : entries) {
            boolean isTopHierarchy = true;
            for (Entry entry : entries) {
                if (!entryToCheck.id.equals(entry.overridenSectionId)) continue;
                isTopHierarchy = false;
                break;
            }
            if (!isTopHierarchy) continue;
            topHierarchyEntries.add(entryToCheck);
        }
        return topHierarchyEntries;
    }

    private class Entry {
        IConfigurationElement element;
        String id;
        String overridenSectionId;
        String profilerId;
        String launchTypeId;

        public Entry(IConfigurationElement element, String id, String overridenSectionId, String debuggerId, String launchTypeId) {
            this.element = element;
            this.id = id;
            this.profilerId = debuggerId;
            this.launchTypeId = launchTypeId;
            this.overridenSectionId = overridenSectionId;
        }
    }
}

