/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.refactoring.core.rename.RenameFileProcessor;
import org.eclipse.php.refactoring.core.test.AbstractPDTTListRefactoringTest;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.junit.Assert;
import org.junit.Test;

public class RenameResourceProcessorTest
extends AbstractPDTTListRefactoringTest {
    @PDTTList.Parameters
    public static String[] dirs = new String[]{"/resources/rename/renameResource/"};

    public RenameResourceProcessorTest(String[] fileNames) {
        super(fileNames);
    }

    @Test
    public void testRename(String fileName) throws Exception {
        PdttFileExt testFile = (PdttFileExt)((Object)this.filesMap.get(fileName));
        IFile file = this.project.findFile(testFile.getTestFiles().get(0).getName());
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        RenameFileProcessor processor = new RenameFileProcessor((IResource)file, program);
        processor.setNewElementName((String)testFile.getConfig().get("newName"));
        processor.setUpdateRefernces(Boolean.valueOf((String)testFile.getConfig().get("updateReference")).booleanValue());
        processor.setAttribute("org.eclipse.php.refactoring.core.rename.resource.classname", (String)testFile.getConfig().get("updateClassName"));
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        this.checkTestResult(testFile);
    }
}

