/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.filenetwork.FileUtil;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.osgi.framework.BundleContext;

public class ComposerCoreTestPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.php.composer.tests";
    private static ComposerCoreTestPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        PHPCorePlugin.toolkitInitialized = true;
        TestUtils.disableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        TestUtils.enableColliders((TestUtils.ColliderType)TestUtils.ColliderType.ALL);
        super.stop(context);
    }

    public static ComposerCoreTestPlugin getDefault() {
        return plugin;
    }

    private static String getDiffError(String expected, String actual, int expectedDiff, int actualDiff) {
        StringBuilder errorBuf = new StringBuilder();
        errorBuf.append("\nEXPECTED:\n--------------\n");
        errorBuf.append(expected.substring(0, expectedDiff)).append("*****").append(expected.substring(expectedDiff));
        errorBuf.append("\n\nACTUAL:\n--------------\n");
        errorBuf.append(actual.substring(0, actualDiff)).append("*****").append(actual.substring(actualDiff));
        return errorBuf.toString();
    }

    public static String compareContents(String expected, String actual) {
        int expectedDiff = StringUtils.indexOfDifference((CharSequence)(actual = actual.replaceAll("[\r\n]+", "\n").trim()), (CharSequence)(expected = expected.replaceAll("[\r\n]+", "\n").trim()));
        if (expectedDiff >= 0) {
            int actualDiff = StringUtils.indexOfDifference((CharSequence)expected, (CharSequence)actual);
            return ComposerCoreTestPlugin.getDiffError(expected, actual, expectedDiff, actualDiff);
        }
        return null;
    }

    public static String compareContentsIgnoreWhitespace(String expected, String actual) {
        String tmpExpected = expected;
        String tmpActual = actual;
        String diff = StringUtils.difference((String)tmpExpected, (String)tmpActual);
        while (diff.length() > 0) {
            String diff2 = StringUtils.difference((String)tmpActual, (String)tmpExpected);
            if (!Character.isWhitespace(diff.charAt(0)) && !Character.isWhitespace(diff2.charAt(0))) {
                int expectedDiff = StringUtils.indexOfDifference((CharSequence)tmpActual, (CharSequence)tmpExpected) + (expected.length() - tmpExpected.length());
                int actualDiff = StringUtils.indexOfDifference((CharSequence)tmpExpected, (CharSequence)tmpActual) + (actual.length() - tmpActual.length());
                return ComposerCoreTestPlugin.getDiffError(expected, actual, expectedDiff, actualDiff);
            }
            tmpActual = diff.trim();
            tmpExpected = diff2.trim();
            diff = StringUtils.difference((String)tmpExpected, (String)tmpActual);
        }
        return null;
    }

    public static void copyProjectFiles(IProject project) throws IOException {
        FileUtil.copyDirectory((File)new File(FileLocator.toFileURL((URL)ComposerCoreTestPlugin.getDefault().getBundle().getEntry("/workspace/" + project.getName())).getFile()), (File)new File(project.getLocationURI()));
    }
}

