/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.filenetwork;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.filenetwork.AbstractModelTests;
import org.eclipse.php.core.tests.filenetwork.SuiteOfTestCases;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.junit.ClassRule;
import org.junit.rules.TestWatcher;

public class FileNetworkTests
extends AbstractModelTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    protected static final String PROJECT = "filenetwork";
    protected IScriptProject SCRIPT_PROJECT;

    public FileNetworkTests(String name) {
        super("org.eclipse.php.core.tests", name);
    }

    @Override
    public void setUpSuite() throws Exception {
        this.deleteProject(PROJECT);
        if (this.SCRIPT_PROJECT != null) {
            this.SCRIPT_PROJECT.close();
            this.SCRIPT_PROJECT = null;
        }
        super.setUpSuite();
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject(PROJECT);
        super.tearDownSuite();
    }

    protected void setUp() throws Exception {
        if (this.SCRIPT_PROJECT == null) {
            this.SCRIPT_PROJECT = this.setUpScriptProject(PROJECT);
            TestUtils.waitForIndexer();
        }
        super.setUp();
    }

    protected String getSavedHierarchy(String subfolder) throws CoreException, IOException {
        String l;
        IFile file = this.getFile(this.getFilePath(String.valueOf(subfolder) + "/hierarchy"));
        StringBuilder buf = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(file.getContents()));
        while ((l = r.readLine()) != null) {
            buf.append(l).append("\n");
        }
        r.close();
        return buf.toString();
    }

    public static Test suite() {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite(FileNetworkTests.class);
        return suite;
    }

    protected String sortLines(String str) {
        Object[] split = str.split("[\r\n]+");
        Arrays.sort(split);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < split.length) {
            if (i > 0) {
                buf.append("\n");
            }
            buf.append((String)split[i]);
            ++i;
        }
        return buf.toString();
    }

    protected void assertContents(String expected, String actual) {
        String diff = TestUtils.compareContents(expected = this.sortLines(expected), actual = this.sortLines(actual));
        if (diff != null) {
            FileNetworkTests.fail((String)diff);
        }
    }

    protected String getFilePath(String projectRelativePath) {
        return "/filenetwork/" + projectRelativePath;
    }

    public void testReferencingFiles() throws Exception {
        ISourceModule sourceModule = this.getSourceModule(this.getFilePath("test1/a.php"));
        ReferenceTree tree = FileNetworkUtility.buildReferencingFilesTree((ISourceModule)sourceModule, null);
        this.assertContents(this.getSavedHierarchy("test1"), tree.toString());
    }

    public void testReferencedFiles() throws Exception {
        ISourceModule sourceModule = this.getSourceModule(this.getFilePath("test2/a.php"));
        ReferenceTree tree = FileNetworkUtility.buildReferencedFilesTree((ISourceModule)sourceModule, null);
        this.assertContents(this.getSavedHierarchy("test2"), tree.toString());
    }

    public void testCachedReferencedFiles() throws Exception {
        ISourceModule sourceModule = this.getSourceModule(this.getFilePath("test2/a.php"));
        HashMap cache = new HashMap();
        ReferenceTree tree = FileNetworkUtility.buildReferencedFilesTree((ISourceModule)sourceModule, cache, null);
        tree = FileNetworkUtility.buildReferencedFilesTree((ISourceModule)sourceModule, cache, null);
        this.assertContents(this.getSavedHierarchy("test2"), tree.toString());
    }

    public void testSearchMethod() throws Exception {
        ISourceModule sourceModule = this.getSourceModule(this.getFilePath("test3/c.php"));
        IType type = sourceModule.getType("Test3");
        IMethod[] method = PHPModelUtils.getTypeHierarchyMethod((IType)type, (String)"foo", (boolean)true, null);
        FileNetworkTests.assertTrue((String)"Can't find method", (method.length > 0 ? 1 : 0) != 0);
        FileNetworkTests.assertEquals((String)"Wrong method was found", (String)"a.php", (String)method[0].getSourceModule().getElementName());
    }

    public void testSearchMethodBadNetwork() throws Exception {
        ISourceModule sourceModule = this.getSourceModule(this.getFilePath("test4/c.php"));
        IType type = sourceModule.getType("Test4");
        IMethod[] method = PHPModelUtils.getTypeHierarchyMethod((IType)type, (String)"foo", (boolean)true, null);
        FileNetworkTests.assertTrue((String)"There should be two methods found", (method.length == 2 ? 1 : 0) != 0);
    }
}

