/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.collection.ComposerPackages;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.ui.actions.ToggleDevAction;
import org.eclipse.php.composer.ui.controller.GraphController;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.composer.ComposerFormEditor;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.editor.toolbar.SearchControl;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class DependencyGraphPage
extends ComposerFormPage
implements ModifyListener {
    private static final String SEARCH_ID = "composer.dpg.search";
    private static final String SEPARATOR_ID = "composer.dpg.separator";
    public static final String ID = "org.eclipse.php.composer.ui.editor.composer.DependencyGraphPage";
    protected ComposerFormEditor editor;
    private GraphController graphController;
    private GraphViewer viewer;
    private IComposerProject composerProject;
    private IProject project;
    private SearchControl searchControl;
    private IToolBarManager manager;

    public DependencyGraphPage(ComposerFormEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
        this.editor = editor;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.editor.getHeaderForm().getForm().setText(Messages.DependencyGraphPage_Title);
        }
        active = active && this.editor.isValidJson();
        this.manager.find("composer.dpg.toggle").setVisible(active);
        this.manager.find(SEPARATOR_ID).setVisible(active);
        this.searchControl.setVisible(active);
        this.manager.update(true);
        this.viewer.getControl().setEnabled(active);
        if (active) {
            this.update();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        try {
            this.createGraph(managedForm);
        }
        catch (IOException e) {
            Logger.logException((Throwable)e);
        }
    }

    private void createGraph(IManagedForm managedForm) throws IOException {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.project = this.getComposerEditor().getProject();
        this.composerProject = ComposerPlugin.getDefault().getComposerProject(this.project);
        this.graphController = new GraphController(this.composerProject);
        this.graphController.setComposerProject(this.composerProject);
        this.viewer = new GraphViewer(body, 0x100000);
        this.viewer.setConnectionStyle(2);
        this.viewer.setContentProvider((IContentProvider)this.graphController);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.graphController);
        this.viewer.setLayoutAlgorithm(this.setLayout());
        this.viewer.applyLayout();
        DevFilter filter = new DevFilter();
        ViewerFilter[] filters = new ViewerFilter[]{filter};
        this.viewer.setFilters(filters);
        this.update();
    }

    @Override
    public void contributeToToolbar(IToolBarManager manager, IManagedForm headerForm) {
        this.manager = manager;
        this.searchControl = new SearchControl(SEARCH_ID, headerForm);
        this.searchControl.setVisible(false);
        this.searchControl.addModifyListener(this);
        manager.add((IContributionItem)this.searchControl);
        manager.add((IAction)new ToggleDevAction(this));
        manager.find("composer.dpg.toggle").setVisible(false);
        Separator graphSeparator = new Separator();
        graphSeparator.setId(SEPARATOR_ID);
        graphSeparator.setVisible(false);
        manager.add((IContributionItem)graphSeparator);
    }

    private LayoutAlgorithm setLayout() {
        CompositeLayoutAlgorithm layout = new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{new TreeLayoutAlgorithm(1), new HorizontalShift(1)});
        return layout;
    }

    protected void update() {
        if (this.composerProject != null && this.viewer != null && !this.viewer.getControl().isDisposed() && this.editor.isValidJson()) {
            ComposerPackages packages = this.composerProject.getInstalledPackages();
            packages.add((Object)this.composerProject.getComposerPackage());
            this.viewer.setInput((Object)packages);
            this.applyFilter(true);
        }
    }

    public void applyFilter(boolean showDev) {
        DevFilter filter = new DevFilter();
        if (!showDev) {
            filter.hideDevPackages();
        }
        ViewerFilter[] filters = new ViewerFilter[]{filter};
        this.viewer.setFilters(filters);
        this.viewer.applyLayout();
    }

    public void modifyText(ModifyEvent e) {
        this.graphController.setFilterText(this.searchControl.getText());
        this.viewer.refresh();
    }

    private class DevFilter
    extends ViewerFilter {
        protected boolean showDev = true;

        private DevFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.showDev) {
                return true;
            }
            if (element instanceof ComposerPackage) {
                return !DependencyGraphPage.this.composerProject.getComposerPackage().getRequireDev().has((VersionedPackage)((ComposerPackage)element));
            }
            return true;
        }

        public void hideDevPackages() {
            this.showDev = false;
        }
    }
}

