/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;

public class SelectionManager {
    private EditPart focusPart;
    private Runnable notifier;
    private List<EditPart> selection;
    private EditPartViewer viewer;

    protected SelectionManager() {
    }

    public static SelectionManager createDefault() {
        return new SelectionManager();
    }

    public void appendSelection(EditPart editpart) {
        Objects.requireNonNull(editpart, "The selected edit part must not be null.");
        if (editpart != this.getFocus()) {
            this.viewer.setFocus(null);
        }
        if (!this.selection.isEmpty()) {
            EditPart primary = this.selection.get(this.selection.size() - 1);
            primary.setSelected(1);
        }
        this.selection.remove(editpart);
        this.selection.add(editpart);
        editpart.setSelected(2);
        this.fireSelectionChanged();
    }

    public void deselect(EditPart editpart) {
        editpart.setSelected(0);
        this.selection.remove(editpart);
        if (!this.selection.isEmpty()) {
            int i = this.selection.size() - 1;
            while (i >= 0) {
                EditPart primaryCandidate = this.selection.get(i);
                if (primaryCandidate.isSelectable()) {
                    primaryCandidate.setSelected(2);
                    break;
                }
                --i;
            }
        }
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        this.viewer.setFocus(null);
        this.selection.forEach(ep -> ep.setSelected(0));
        this.selection.clear();
        this.fireSelectionChanged();
    }

    protected final void fireSelectionChanged() {
        this.notifier.run();
    }

    protected EditPart getFocus() {
        return this.focusPart;
    }

    public ISelection getSelection() {
        if (this.selection.isEmpty() && this.viewer.getContents() != null) {
            return new StructuredSelection((Object)this.viewer.getContents());
        }
        return new StructuredSelection(this.selection);
    }

    protected EditPartViewer getViewer() {
        return this.viewer;
    }

    public void internalHookControl(Control control) {
    }

    public void internalUninstall() {
    }

    protected void hookViewer(EditPartViewer viewer) {
    }

    public void internalInitialize(EditPartViewer viewer, List<EditPart> selection, Runnable notifier) {
        this.viewer = viewer;
        this.selection = selection;
        this.notifier = notifier;
        this.hookViewer(viewer);
    }

    public void setFocus(EditPart part) {
        if (this.viewer instanceof AbstractEditPartViewer) {
            try {
                Field focusPartField = AbstractEditPartViewer.class.getDeclaredField("focusPart");
                focusPartField.setAccessible(true);
                if (focusPartField.get(this.viewer) != part) {
                    focusPartField.set(this.viewer, part);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Workaround for bug #458416 became ineffective");
            }
        }
        if (this.focusPart == part) {
            return;
        }
        if (this.focusPart != null) {
            this.focusPart.setFocus(false);
        }
        this.focusPart = part;
        if (this.focusPart != null) {
            this.focusPart.setFocus(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSelection(ISelection newSelection) {
        void structuredSelection;
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)newSelection;
        List orderedSelection = structuredSelection.toList();
        Set set = Set.copyOf(orderedSelection);
        this.viewer.setFocus(null);
        for (EditPart part : this.selection) {
            if (set.contains(part)) continue;
            part.setSelected(0);
        }
        this.selection.clear();
        Iterator itr = orderedSelection.iterator();
        while (itr.hasNext()) {
            EditPart part = (EditPart)itr.next();
            this.selection.add(part);
            part.setSelected(itr.hasNext() ? 1 : 2);
        }
        this.fireSelectionChanged();
    }
}

