/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class LogicFlowContainer
extends LogicDiagram {
    public static String ID_LAYOUT = "layout";
    public static Integer LAYOUT_MULTI_ROW = new Integer(0);
    public static Integer LAYOUT_SINGLE_ROW = new Integer(1);
    static final long serialVersionUID = 1L;
    protected Integer layout = LAYOUT_MULTI_ROW;

    public Integer getLayout() {
        if (this.layout == null) {
            return LAYOUT_MULTI_ROW;
        }
        return this.layout;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getClass().equals(LogicFlowContainer.class)) {
            ComboBoxPropertyDescriptor cbd = new ComboBoxPropertyDescriptor((Object)ID_LAYOUT, LogicMessages.PropertyDescriptor_LogicFlowContainer_Layout, new String[]{LogicMessages.PropertyDescriptor_LogicFlowContainer_MultiRowLayout, LogicMessages.PropertyDescriptor_LogicFlowContainer_SingleColumnLayout});
            cbd.setLabelProvider((ILabelProvider)new LayoutLabelProvider());
            return new IPropertyDescriptor[]{cbd, descriptors[0], descriptors[1]};
        }
        return super.getPropertyDescriptors();
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if (propName.equals(ID_LAYOUT)) {
            return this.layout;
        }
        return super.getPropertyValue(propName);
    }

    public void setLayout(Integer newLayout) {
        Integer oldLayout = this.layout;
        this.layout = newLayout;
        this.firePropertyChange(ID_LAYOUT, oldLayout, this.layout);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (ID_LAYOUT.equals(id)) {
            this.setLayout((Integer)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public String toString() {
        return LogicMessages.LogicPlugin_Tool_CreationTool_FlowContainer_Label;
    }

    private class LayoutLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof Integer) {
                Integer integer = (Integer)element;
                if (LAYOUT_SINGLE_ROW.intValue() == integer.intValue()) {
                    return LogicMessages.PropertyDescriptor_LogicFlowContainer_SingleColumnLayout;
                }
                if (LAYOUT_MULTI_ROW.intValue() == integer.intValue()) {
                    return LogicMessages.PropertyDescriptor_LogicFlowContainer_MultiRowLayout;
                }
            }
            return super.getText(element);
        }
    }
}

