/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextCommand;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.TextUtilities;
import org.eclipse.gef.examples.text.actions.StyleListener;
import org.eclipse.gef.examples.text.actions.StyleProvider;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.edit.TextStyleManager;
import org.eclipse.gef.examples.text.requests.CaretRequest;
import org.eclipse.gef.examples.text.requests.SearchResult;
import org.eclipse.gef.examples.text.requests.TextRequest;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;

public class TextTool
extends SelectionTool
implements StyleProvider {
    static final boolean IS_CARBON = "carbon".equals(SWT.getPlatform());
    private static final int MODE_BS = 2;
    private static final int MODE_DEL = 3;
    private static final int MODE_TYPE = 1;
    private static final String KEY_OVERWRITE = "gef.texttool.overwrite";
    private CommandStackEventListener commandListener = new CommandStackEventListener(){

        public void stackChanged(CommandStackEvent event) {
            if ((event.getDetail() & CommandStack.POST_MASK) != 0) {
                TextTool.this.fireStyleChanges();
                TextTool.this.discardCaretLocation();
            }
        }
    };
    private StyleListener listener;
    private AppendableCommand pendingCommand;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TextTool.this.fireStyleChanges();
            TextTool.this.getCaret().setVisible(TextTool.this.getSelectionRange() != null);
            TextTool.this.queueCaretRefresh(true);
        }
    };
    private UpdateListener updateListener = new UpdateListener(){

        public void notifyPainting(Rectangle damage, Map dirtyRegions) {
            TextTool.this.queueCaretRefresh(false);
        }

        public void notifyValidating() {
        }
    };
    private List styleKeys = new ArrayList();
    private final StyleService styleService;
    private List styleValues = new ArrayList();
    private CaretRefresh caretRefresh;
    private int textInputMode;
    private int caretXLoc;
    private boolean isMirrored;
    private boolean xCaptured;
    private boolean overwrite;

    public TextTool() {
        this(null);
    }

    public TextTool(StyleService service) {
        this.styleService = service;
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        Assert.isTrue((this.listener == null ? 1 : 0) != 0);
        this.listener = listener;
    }

    protected Cursor calculateCursor() {
        TextEditPart textTarget;
        EditPart target = this.getTargetEditPart();
        if (target instanceof TextEditPart && (textTarget = (TextEditPart)target).acceptsCaret()) {
            return Cursors.IBEAM;
        }
        return super.calculateCursor();
    }

    private void recordCaretLocation() {
        if (!this.xCaptured) {
            this.caretXLoc = this.getCaretBounds().x;
            this.xCaptured = true;
        }
    }

    private void discardCaretLocation() {
        this.xCaptured = false;
    }

    private void doAction(int action, KeyEvent event) {
        boolean append = false;
        this.getUpdateManager().performUpdate();
        this.setTextInputMode(0);
        event.doit = false;
        if (action == 0x1000006 || action == 16908294 || action == 0x1000005 || action == 16908293 || action == 0x1020002 || action == 0x1000002 || action == 0x1020001 || action == 0x1000001) {
            this.recordCaretLocation();
        } else {
            this.discardCaretLocation();
        }
        switch (action) {
            case 17170439: {
                append = true;
            }
            case 17039367: {
                this.doSelect(CaretRequest.DOCUMENT, false, append, null);
                break;
            }
            case 17170440: {
                append = true;
            }
            case 17039368: {
                this.doSelect(CaretRequest.DOCUMENT, true, append, null);
                break;
            }
            case 16908294: {
                append = true;
            }
            case 0x1000006: {
                this.doTraversePage(true, append);
                break;
            }
            case 16908293: {
                append = true;
            }
            case 0x1000005: {
                this.doTraversePage(false, append);
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 16908295: {
                append = true;
            }
            case 0x1000007: {
                this.doSelect(CaretRequest.LINE_BOUNDARY, false, append, null);
                break;
            }
            case 17170436: {
                append = true;
            }
            case 0x1040004: {
                this.doSelect(CaretRequest.WORD_BOUNDARY, true, append, null);
                break;
            }
            case 17170435: {
                append = true;
            }
            case 17039363: {
                this.doSelect(CaretRequest.WORD_BOUNDARY, false, append, null);
                break;
            }
            case 16908296: {
                append = true;
            }
            case 0x1000008: {
                this.doSelect(CaretRequest.LINE_BOUNDARY, true, append, null);
                break;
            }
            case 16908291: {
                append = true;
            }
            case 0x1000003: {
                this.doSelect(CaretRequest.COLUMN, false, append, null);
                break;
            }
            case 16908292: {
                append = true;
            }
            case 0x1000004: {
                this.doSelect(CaretRequest.COLUMN, true, append, null);
                break;
            }
            case 0x1020001: {
                append = true;
            }
            case 0x1000001: {
                this.doSelect(CaretRequest.ROW, false, append, null);
                break;
            }
            case 0x1020002: {
                append = true;
            }
            case 0x1000002: {
                this.doSelect(CaretRequest.ROW, true, append, null);
                break;
            }
            case 0x1060006: {
                append = true;
            }
            case 17039366: {
                this.doSelect(CaretRequest.WINDOW, true, append, null);
                break;
            }
            case 17170437: {
                append = true;
            }
            case 17039365: {
                this.doSelect(CaretRequest.WINDOW, false, append, null);
                break;
            }
            case 0x1000009: {
                this.toggleOverwrite();
                break;
            }
            case 131081: {
                this.doUnindent();
                break;
            }
            case 9: {
                if (this.doIndent()) break;
                this.doTyping(event);
                break;
            }
            case 13: {
                if (this.doNewline()) break;
                this.doTyping(event);
                break;
            }
            default: {
                event.doit = true;
            }
        }
    }

    private boolean doBackspace() {
        this.setTextInputMode(2);
        SelectionRange range = this.getSelectionRange();
        if (range.isEmpty()) {
            if (this.handleTextEdit(new TextRequest(TextRequest.REQ_BACKSPACE, range, this.pendingCommand))) {
                return true;
            }
            this.doSelect(CaretRequest.COLUMN, false, false, null);
            return false;
        }
        return this.handleTextEdit(new TextRequest(TextRequest.REQ_REMOVE_RANGE, range));
    }

    private boolean doDelete() {
        this.setTextInputMode(3);
        SelectionRange range = this.getSelectionRange();
        if (range.isEmpty()) {
            if (this.handleTextEdit(new TextRequest(TextRequest.REQ_DELETE, range, this.pendingCommand))) {
                return true;
            }
            this.doSelect(CaretRequest.COLUMN, true, false, null);
            return false;
        }
        return this.handleTextEdit(new TextRequest(TextRequest.REQ_REMOVE_RANGE, range));
    }

    private boolean doIndent() {
        this.setTextInputMode(0);
        SelectionRange range = this.getSelectionRange();
        if (!range.isEmpty()) {
            return false;
        }
        TextRequest edit = new TextRequest(TextRequest.REQ_INDENT, range);
        return this.handleTextEdit(edit);
    }

    private boolean doInsertContent(char c) {
        this.setTextInputMode(1);
        TextRequest edit = new TextRequest(this.overwrite ? TextRequest.REQ_OVERWRITE : TextRequest.REQ_INSERT, this.getSelectionRange(), Character.toString(c), this.pendingCommand);
        String[] keys = new String[this.styleKeys.size()];
        this.styleKeys.toArray(keys);
        edit.setStyles(keys, this.styleValues.toArray());
        return this.handleTextEdit(edit);
    }

    private void doKeyDown(KeyEvent event) {
        int action = 0;
        if (event.keyCode != 0) {
            action = this.lookupAction(event.keyCode | event.stateMask);
        } else {
            action = this.lookupAction(event.character | event.stateMask);
            if (action == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                int c = event.character + 64;
                action = this.lookupAction(c | event.stateMask);
            }
        }
        if (action == 0) {
            this.doTyping(event);
        } else {
            this.doAction(action, event);
        }
    }

    private boolean doNewline() {
        this.setTextInputMode(2);
        SelectionRange range = this.getSelectionRange();
        Assert.isTrue((boolean)range.isEmpty());
        TextRequest edit = new TextRequest(TextRequest.REQ_NEWLINE, range, this.pendingCommand);
        return this.handleTextEdit(edit);
    }

    private void doSelect(Object type, boolean isForward, boolean append, Point loc) {
        GraphicalTextViewer viewer = this.getTextualViewer();
        SearchResult result = new SearchResult();
        CaretRequest search = new CaretRequest();
        search.setType(type);
        search.isForward = isForward;
        search.setLocation(loc);
        SelectionRange range = this.getSelectionRange();
        if (range == null) {
            TextEditPart tep;
            if (viewer.getContents() instanceof TextEditPart && (tep = (TextEditPart)viewer.getContents()).acceptsCaret()) {
                tep.getTextLocation(search, result);
            }
        } else {
            TextLocation caretLocation = this.getCaretLocation();
            if (loc == null) {
                search.setLocation(new Point(this.xCaptured ? this.caretXLoc : this.getCaretBounds().x, this.getCaretInfo().getBaseline()));
            }
            search.where = caretLocation;
            caretLocation.part.getTextLocation(search, result);
        }
        if (result.location == null) {
            return;
        }
        if (append) {
            TextLocation otherEnd = isForward ? range.begin : range.end;
            range = TextUtilities.isForward(otherEnd, result.location) ? new SelectionRange(otherEnd, result.location, true, result.trailing) : new SelectionRange(result.location, otherEnd, false, result.trailing);
            viewer.setSelectionRange(range);
        } else {
            viewer.setSelectionRange(new SelectionRange(result.location, result.location, isForward, result.trailing));
        }
    }

    private void doTraversePage(boolean isForward, boolean appendSelection) {
        Rectangle caretBounds = this.getCaretBounds();
        Point loc = caretBounds.getCenter();
        loc.x = this.caretXLoc;
        int viewerHeight = this.getTextualViewer().getControl().getBounds().height - caretBounds.height;
        loc.y = isForward ? (loc.y += viewerHeight) : (loc.y -= viewerHeight);
        this.doSelect(CaretRequest.LOCATION, isForward, appendSelection, loc);
    }

    private void doTyping(KeyEvent event) {
        boolean ignore = false;
        this.discardCaretLocation();
        if (IS_CARBON) {
            ignore = (event.stateMask ^ 0x400000) == 0 || (event.stateMask ^ 0x420000) == 0;
        } else {
            boolean bl = ignore = (event.stateMask ^ 0x10000) == 0 || (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x30000) == 0 || (event.stateMask ^ 0x60000) == 0;
        }
        if (!ignore && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
            this.doInsertContent(event.character);
            event.doit = false;
        }
    }

    private boolean doUnindent() {
        this.setTextInputMode(0);
        SelectionRange range = this.getSelectionRange();
        if (!range.isEmpty()) {
            return false;
        }
        TextRequest edit = new TextRequest(TextRequest.REQ_UNINDENT, range);
        return this.handleTextEdit(edit);
    }

    private void fireStyleChanges() {
        if (this.listener != null) {
            this.listener.styleChanged(null);
        }
    }

    private void flushStyles() {
        this.styleKeys.clear();
        this.styleValues.clear();
    }

    private Caret getCaret() {
        Canvas canvas;
        Caret caret = null;
        if (this.getCurrentViewer() != null && (caret = (canvas = (Canvas)this.getCurrentViewer().getControl()).getCaret()) == null) {
            caret = new Caret(canvas, 0);
        }
        return caret;
    }

    public Rectangle getCaretBounds() {
        return new Rectangle(this.getCaret().getBounds());
    }

    public CaretInfo getCaretInfo() {
        TextLocation location = this.getCaretLocation();
        return location.part.getCaretPlacement(location.offset, this.getSelectionRange().trailing);
    }

    public TextLocation getCaretLocation() {
        if (this.getSelectionRange().isForward) {
            return this.getSelectionRange().end;
        }
        return this.getSelectionRange().begin;
    }

    public TextEditPart getCaretOwner() {
        if (this.getSelectionRange() != null) {
            return this.getCaretLocation().part;
        }
        return null;
    }

    private SelectionRange getSelectionRange() {
        if (this.getCurrentViewer() instanceof GraphicalTextViewer) {
            return this.getTextualViewer().getSelectionRange();
        }
        return null;
    }

    private UpdateManager getUpdateManager() {
        RootEditPart root;
        EditPartViewer viewer = this.getCurrentViewer();
        if (viewer != null && (root = viewer.getRootEditPart()) instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)root).getFigure().getUpdateManager();
        }
        return null;
    }

    private Object getSelectionStyle(String styleID, boolean isState) {
        TextRequest req = new TextRequest(TextRequest.REQ_STYLE, this.getSelectionRange());
        req.setStyles(new String[]{styleID}, new Object[1]);
        TextEditPart target = this.getTextTarget(req);
        if (target == null) {
            return StyleService.UNDEFINED;
        }
        TextStyleManager manager = (TextStyleManager)target.getAdapter(TextStyleManager.class);
        if (isState) {
            return manager.getStyleState(styleID, this.getSelectionRange());
        }
        return manager.getStyleValue(styleID, this.getSelectionRange());
    }

    @Override
    public Object getStyle(String styleID) {
        int i = 0;
        while (i < this.styleKeys.size()) {
            if (styleID.equals(this.styleKeys.get(i))) {
                return this.styleValues.get(i);
            }
            ++i;
        }
        return this.getSelectionStyle(styleID, false);
    }

    @Override
    public Object getStyleState(String styleID) {
        return this.getSelectionStyle(styleID, true);
    }

    private TextEditPart getTextTarget(Request request) {
        EditPart target;
        SelectionRange range = this.getSelectionRange();
        if (range == null) {
            return null;
        }
        EditPart candidate = ToolUtilities.findCommonAncestor((EditPart)range.begin.part, (EditPart)range.end.part);
        do {
            target = candidate.getTargetEditPart(request);
            candidate = candidate.getParent();
        } while (target == null && candidate != null);
        return (TextEditPart)target;
    }

    GraphicalTextViewer getTextualViewer() {
        return (GraphicalTextViewer)this.getCurrentViewer();
    }

    protected boolean handleButtonDown(int button) {
        this.discardCaretLocation();
        return super.handleButtonDown(button);
    }

    protected boolean handleCommandStackChanged() {
        this.setTextInputMode(0);
        this.discardCaretLocation();
        return super.handleCommandStackChanged();
    }

    protected boolean handleFocusGained() {
        if (this.getSelectionRange() == null) {
            this.doSelect(CaretRequest.DOCUMENT, false, false, null);
        }
        return super.handleFocusGained();
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.isInState(1) && this.getTextualViewer().isTextSelected()) {
            this.doKeyDown(e);
        }
        if (e.doit) {
            return super.handleKeyDown(e);
        }
        return true;
    }

    protected void handleKeyTraversed(TraverseEvent event) {
        if ((event.detail == 8 || event.detail == 16) && (event.stateMask & 0x40000) == 0) {
            event.doit = false;
        }
    }

    protected boolean handleMove() {
        super.handleMove();
        this.refreshCursor();
        return true;
    }

    private boolean handleTextEdit(TextRequest edit) {
        GraphicalTextViewer viewer = this.getTextualViewer();
        TextEditPart target = this.getTextTarget(edit);
        Command insert = null;
        if (target != null) {
            insert = target.getCommand(edit);
        }
        if (insert == null) {
            return false;
        }
        if (this.pendingCommand == null || insert != this.pendingCommand) {
            if (!insert.canExecute()) {
                return false;
            }
            this.executeCommand(insert);
            this.pendingCommand = insert instanceof AppendableCommand ? (AppendableCommand)insert : null;
        } else {
            if (!this.pendingCommand.canExecutePending()) {
                return false;
            }
            this.pendingCommand.executePending();
            viewer.setSelectionRange(((TextCommand)((Object)this.pendingCommand)).getExecuteSelectionRange(viewer));
        }
        return true;
    }

    private int lookupAction(int i) {
        switch (i) {
            case 0x1000003: {
                return this.isMirrored ? 0x1000004 : 0x1000003;
            }
            case 0x1000004: {
                return this.isMirrored ? 0x1000003 : 0x1000004;
            }
            case 16908292: {
                return this.isMirrored ? 16908291 : 16908292;
            }
            case 16908291: {
                return this.isMirrored ? 16908292 : 16908291;
            }
            case 0x1040004: {
                return this.isMirrored ? 17039363 : 0x1040004;
            }
            case 17170436: {
                return this.isMirrored ? 17170435 : 17170436;
            }
            case 17039363: {
                return this.isMirrored ? 0x1040004 : 17039363;
            }
            case 17170435: {
                return this.isMirrored ? 17170436 : 17170435;
            }
            case 8: 
            case 9: 
            case 127: 
            case 131081: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 0x1000009: 
            case 0x1020001: 
            case 0x1020002: 
            case 16908293: 
            case 16908294: 
            case 16908295: 
            case 16908296: 
            case 17039365: 
            case 17039366: 
            case 17039367: 
            case 17039368: 
            case 17170437: 
            case 0x1060006: 
            case 17170439: 
            case 17170440: {
                return i;
            }
            case 10: 
            case 13: {
                return 13;
            }
        }
        return 0;
    }

    void queueCaretRefresh(boolean revealAfterwards) {
        if (!this.getCaret().isVisible()) {
            return;
        }
        if (this.caretRefresh == null) {
            this.caretRefresh = new CaretRefresh(revealAfterwards);
            this.getUpdateManager().runWithUpdate((Runnable)this.caretRefresh);
        } else {
            this.caretRefresh.enableReveal(revealAfterwards);
        }
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        Assert.isTrue((this.listener == listener ? 1 : 0) != 0);
        this.listener = null;
    }

    public void setDragTracker(DragTracker newDragTracker) {
        if (this.getDragTracker() == newDragTracker) {
            return;
        }
        this.setTextInputMode(0);
        super.setDragTracker(newDragTracker);
    }

    @Override
    public void setStyle(String styleID, Object newValue) {
        int prev;
        Object oldValue = this.getSelectionStyle(styleID, false);
        if (newValue.equals(oldValue) && (prev = this.styleKeys.indexOf(styleID)) != -1) {
            this.styleKeys.remove(prev);
            this.styleValues.remove(prev);
            return;
        }
        TextRequest req = new TextRequest(TextRequest.REQ_STYLE, this.getSelectionRange());
        req.setStyles(new String[]{styleID}, new Object[]{newValue});
        TextEditPart target = this.getTextTarget(req);
        Command c = target.getCommand(req);
        if (c == null) {
            int prev2 = this.styleKeys.indexOf(styleID);
            if (prev2 != -1) {
                this.styleKeys.remove(prev2);
                this.styleValues.remove(prev2);
            }
            this.styleKeys.add(0, styleID);
            this.styleValues.add(0, newValue);
        } else if (c.canExecute()) {
            this.executeCommand(c);
        }
    }

    public void setViewer(EditPartViewer viewer) {
        UpdateManager manager;
        EditPartViewer currentViewer = this.getCurrentViewer();
        if (viewer == currentViewer || viewer == null) {
            return;
        }
        if (currentViewer != null) {
            if (this.caretRefresh != null) {
                this.getUpdateManager().performUpdate();
            }
            currentViewer.getEditDomain().getCommandStack().removeCommandStackEventListener(this.commandListener);
            currentViewer.removeSelectionChangedListener(this.selectionListener);
            manager = this.getUpdateManager();
            if (manager != null) {
                manager.removeUpdateListener(this.updateListener);
            }
            currentViewer.setProperty(KEY_OVERWRITE, (Object)(this.overwrite ? Boolean.TRUE : Boolean.FALSE));
            if (this.styleService != null) {
                this.styleService.setStyleProvider(null);
            }
            this.setTextInputMode(0);
            this.setTargetRequest(null);
        }
        super.setViewer(viewer);
        if (viewer != null) {
            Boolean bool;
            this.isMirrored = (viewer.getControl().getStyle() & 0x8000000) != 0;
            viewer.getEditDomain().getCommandStack().addCommandStackEventListener(this.commandListener);
            viewer.addSelectionChangedListener(this.selectionListener);
            manager = this.getUpdateManager();
            if (manager != null) {
                manager.addUpdateListener(this.updateListener);
            }
            boolean bl = this.overwrite = (bool = (Boolean)viewer.getProperty(KEY_OVERWRITE)) != null && bool != false;
            if (this.styleService != null) {
                this.styleService.setStyleProvider(this);
            }
        }
    }

    private void setTextInputMode(int mode) {
        if (this.textInputMode != mode) {
            this.pendingCommand = null;
        }
        if (this.textInputMode != 1) {
            this.flushStyles();
        }
        this.textInputMode = mode;
    }

    private void toggleOverwrite() {
        this.overwrite = !this.overwrite;
        this.queueCaretRefresh(false);
    }

    class CaretRefresh
    implements Runnable {
        private boolean reveal;

        public CaretRefresh(boolean reveal) {
            this.enableReveal(reveal);
        }

        @Override
        public void run() {
            this.refreshCaret();
            TextTool.this.caretRefresh = null;
            if (this.reveal) {
                TextTool.this.getTextualViewer().revealCaret();
            }
        }

        public void refreshCaret() {
            if (TextTool.this.getCaretOwner() == null) {
                return;
            }
            CaretInfo info = TextTool.this.getCaretInfo();
            TextTool.this.getCaret().setBounds(info.getX(), info.getY(), TextTool.this.overwrite ? info.getHeight() / 2 : 1, info.getHeight());
        }

        public void enableReveal(boolean newVal) {
            this.reveal |= newVal;
        }
    }
}

