/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.SyntaxException;

final class OnigRegExp {
    private static final System.Logger LOGGER = System.getLogger(OnigRegExp.class.getName());
    private static final WarnCallback LOGGER_WARN_CALLBACK = message -> LOGGER.log(System.Logger.Level.WARNING, message);
    private @Nullable OnigString lastSearchString;
    private int lastSearchPosition = -1;
    private @Nullable OnigResult lastSearchResult;
    private final Regex regex;
    private final boolean hasGAnchor;

    OnigRegExp(String source) {
        this.hasGAnchor = source.contains("\\G");
        byte[] pattern = source.getBytes(StandardCharsets.UTF_8);
        try {
            this.regex = new Regex(pattern, 0, pattern.length, 256, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT, LOGGER.isLoggable(System.Logger.Level.WARNING) ? LOGGER_WARN_CALLBACK : WarnCallback.NONE);
        }
        catch (SyntaxException ex) {
            throw new TMException("Parsing regex pattern \"" + source + "\" failed with " + (Object)((Object)ex), ex);
        }
    }

    @Nullable OnigResult search(OnigString str, int startPosition) {
        if (this.hasGAnchor) {
            return this.search(str.bytesUTF8, startPosition, str.bytesCount);
        }
        OnigResult lastSearchResult0 = this.lastSearchResult;
        if (this.lastSearchString == str && this.lastSearchPosition <= startPosition && (lastSearchResult0 == null || lastSearchResult0.locationAt(0) >= startPosition)) {
            return lastSearchResult0;
        }
        this.lastSearchString = str;
        this.lastSearchPosition = startPosition;
        this.lastSearchResult = this.search(str.bytesUTF8, startPosition, str.bytesCount);
        return this.lastSearchResult;
    }

    private @Nullable OnigResult search(byte[] data, int startPosition, int end) {
        Matcher matcher = this.regex.matcher(data);
        int status = matcher.search(startPosition, end, 0);
        if (status != -1) {
            Region region = matcher.getEagerRegion();
            return new OnigResult(region, -1);
        }
        return null;
    }
}

