/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.model.CompleteEnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.IndentForEnter;
import org.eclipse.tm4e.languageconfiguration.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.languageconfiguration.internal.registry.AbstractLanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.WorkingCopyLanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPairSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CommentSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterActionHelper;
import org.eclipse.tm4e.languageconfiguration.internal.supports.IndentForEnterHelper;
import org.eclipse.tm4e.languageconfiguration.internal.supports.IndentRulesSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterSupport;
import org.osgi.service.prefs.BackingStoreException;

public final class LanguageConfigurationRegistryManager
extends AbstractLanguageConfigurationRegistryManager {
    private static final String EXTENSION_LANGUAGE_CONFIGURATIONS = "languageConfigurations";
    private static final String LANGUAGE_CONFIGURATION_ELT = "languageConfiguration";

    public static LanguageConfigurationRegistryManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable LanguageConfigurationDefinition getDefinition(IContentType contentType) {
        LanguageConfigurationDefinition bestFit = null;
        ILanguageConfigurationDefinition[] iLanguageConfigurationDefinitionArray = this.getDefinitions();
        int n = iLanguageConfigurationDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguageConfigurationDefinition iDefinition = iLanguageConfigurationDefinitionArray[n2];
            ILanguageConfigurationDefinition iLanguageConfigurationDefinition = iDefinition;
            if (iLanguageConfigurationDefinition instanceof LanguageConfigurationDefinition) {
                void definition;
                LanguageConfigurationDefinition cfr_ignored_0 = (LanguageConfigurationDefinition)iLanguageConfigurationDefinition;
                LanguageConfigurationDefinition cfr_ignored_1 = (LanguageConfigurationDefinition)iLanguageConfigurationDefinition;
                IContentType definitionContentType = definition.getContentType();
                if (contentType.isKindOf(definitionContentType) && (bestFit == null || definitionContentType.isKindOf(bestFit.getContentType()))) {
                    bestFit = definition;
                }
            }
            ++n2;
        }
        return bestFit;
    }

    public @Nullable AutoClosingPairConditional getAutoClosingPair(String text, int offset, String newCharacter, IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        if (definition == null || !definition.isBracketAutoClosingEnabled()) {
            return null;
        }
        CharacterPairSupport charPairSupport = this._getCharacterPairSupport(contentType);
        return charPairSupport == null ? null : charPairSupport.getAutoClosingPair(text, offset, newCharacter);
    }

    public String getAutoCloseBefore(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        if (definition == null) {
            return ";:.,=}])> \r\n\t";
        }
        CharacterPairSupport charPairSupport = this._getCharacterPairSupport(contentType);
        return charPairSupport == null ? ";:.,=}])> \r\n\t" : charPairSupport.autoCloseBefore;
    }

    public boolean shouldSurroundingPairs(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition != null && definition.isMatchingPairsEnabled();
    }

    public boolean shouldEnterAction(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition != null && definition.isOnEnterEnabled();
    }

    public boolean shouldIndentForEnter(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition != null && definition.isIndentRulesEnabled();
    }

    public boolean shouldComment(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition != null && definition.isOnEnterEnabled();
    }

    public List<AutoClosingPairConditional> getEnabledAutoClosingPairs(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        if (definition == null || !definition.isBracketAutoClosingEnabled()) {
            return Collections.emptyList();
        }
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentType);
        return characterPairSupport == null ? Collections.emptyList() : characterPairSupport.autoClosingPairs;
    }

    public List<AutoClosingPair> getSurroundingPairs(IContentType contentType) {
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentType);
        return characterPairSupport == null ? Collections.emptyList() : characterPairSupport.surroundingPairs;
    }

    public @Nullable CompleteEnterAction getEnterAction(IDocument doc, int offset, IContentType contentType) {
        OnEnterSupport onEnterSupport = this._getOnEnterSupport(contentType);
        return onEnterSupport == null ? null : EnterActionHelper.getEnterAction(doc, offset, onEnterSupport);
    }

    public @Nullable String getGoodIndentForLine(IDocument doc, int offset, IContentType contentType, IndentForEnterHelper.IIndentConverter indentConverter) throws BadLocationException {
        OnEnterSupport onEnterSupport = this._getOnEnterSupport(contentType);
        if (onEnterSupport == null) {
            return null;
        }
        IndentRulesSupport indentRulesSupport = this._getIndentRulesSupport(contentType);
        if (indentRulesSupport == null) {
            return null;
        }
        return IndentForEnterHelper.getGoodIndentForLine(doc, offset, indentConverter, indentRulesSupport, onEnterSupport);
    }

    public @Nullable IndentForEnter getIndentForEnter(IDocument doc, int offset, IContentType contentType, IndentForEnterHelper.IIndentConverter indentConverter) {
        IndentRulesSupport indentRulesSupport = this._getIndentRulesSupport(contentType);
        return indentRulesSupport == null ? null : IndentForEnterHelper.getIndentForEnter(doc, offset, indentConverter, indentRulesSupport);
    }

    public @Nullable CommentSupport getCommentSupport(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition == null ? null : definition.getCommentSupport();
    }

    private @Nullable OnEnterSupport _getOnEnterSupport(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition == null ? null : definition.getOnEnter();
    }

    private @Nullable IndentRulesSupport _getIndentRulesSupport(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition == null ? null : definition.getIndentRules();
    }

    private @Nullable CharacterPairSupport _getCharacterPairSupport(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        return definition == null ? null : definition.getCharacterPair();
    }

    private void load() {
        this.loadFromExtensionPoints();
        this.loadFromPreferences();
    }

    private void loadFromExtensionPoints() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.languageconfiguration", EXTENSION_LANGUAGE_CONFIGURATIONS);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElem = iConfigurationElementArray[n2];
            String name = configElem.getName();
            if (LANGUAGE_CONFIGURATION_ELT.equals(name)) {
                try {
                    this.registerLanguageConfigurationDefinition(new LanguageConfigurationDefinition(configElem));
                }
                catch (CoreException ex) {
                    LanguageConfigurationPlugin.log(ex.getStatus());
                }
            }
            ++n2;
        }
    }

    private void loadFromPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.languageconfiguration");
        String json = prefs.get("org.eclipse.tm4e.languageConfigurations", null);
        if (json != null) {
            ILanguageConfigurationDefinition[] definitions;
            ILanguageConfigurationDefinition[] iLanguageConfigurationDefinitionArray = definitions = PreferenceHelper.loadLanguageConfigurationDefinitions(json);
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                ILanguageConfigurationDefinition definition = iLanguageConfigurationDefinitionArray[n2];
                this.registerLanguageConfigurationDefinition(definition);
                ++n2;
            }
        }
    }

    void save() throws BackingStoreException {
        ArrayList<ILanguageConfigurationDefinition> definitions = new ArrayList<ILanguageConfigurationDefinition>();
        this.userDefinitions.values().forEach(definitions::add);
        this.pluginDefinitions.values().forEach(def -> {
            if (!(def.isBracketAutoClosingEnabled() && def.isMatchingPairsEnabled() && def.isOnEnterEnabled())) {
                definitions.add((ILanguageConfigurationDefinition)def);
            }
        });
        String json = PreferenceHelper.toJson(definitions);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.languageconfiguration");
        prefs.put("org.eclipse.tm4e.languageConfigurations", json);
        prefs.flush();
    }

    @Override
    public ILanguageConfigurationRegistryManager.EditSession newEditSession() {
        return new WorkingCopyLanguageConfigurationRegistryManager(this);
    }

    private static final class InstanceHolder {
        static final LanguageConfigurationRegistryManager INSTANCE = new LanguageConfigurationRegistryManager();

        static {
            INSTANCE.load();
        }

        private InstanceHolder() {
        }
    }
}

