/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.messages;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.rse.services.clientserver.messages.IndicatorException;

public class SystemMessage {
    public static final char COMPLETION = 'C';
    public static final char INQUIRY = 'Q';
    public static final char INFORMATION = 'I';
    public static final char ERROR = 'E';
    public static final char WARNING = 'W';
    public static final char UNEXPECTED = 'U';
    private char subPrefix = (char)37;
    private char indicator;
    private String level1NS;
    private String level2NS;
    private String level1WS;
    private String level2WS;
    private String component;
    private String subComponent;
    private String messageNumber;
    private int numSubs = -1;
    private Object[] subs = null;
    protected static final String NESTING_INDENT = "  ";

    public SystemMessage(String comp, String sub, String number, char ind, String l1, String l2) {
        this.component = comp.toUpperCase();
        this.subComponent = sub.toUpperCase();
        this.messageNumber = number.toUpperCase();
        try {
            this.setIndicator(ind);
        }
        catch (IndicatorException indicatorException) {
            this.indicator = (char)85;
        }
        if (l1 != null) {
            this.level1NS = l1.trim();
            this.level1WS = l1.trim();
        }
        if (l2 != null) {
            this.level2NS = l2.trim();
            this.level2WS = l2.trim();
        }
    }

    public void setIndicator(char ind) throws IndicatorException {
        if (ind != 'Q' && ind != 'I' && ind != 'E' && ind != 'W' && ind != 'U' && ind != 'C') {
            throw new IndicatorException("Indicator specified not valid. Unable to set Indicator.");
        }
        this.indicator = ind;
    }

    public char getIndicator() {
        return this.indicator;
    }

    public String getMessageNumber() {
        return this.messageNumber;
    }

    public int getNumSubstitutionVariables() {
        if (this.numSubs >= 0) {
            return this.numSubs;
        }
        this.numSubs = 0;
        String allText = String.valueOf(this.level1NS) + " " + this.level2NS;
        String subVar = String.valueOf(this.subPrefix) + new Integer(this.numSubs + 1).toString();
        int subLoc = allText.indexOf(subVar);
        while (subLoc >= 0) {
            if (subLoc == 0 && !Character.isDigit(allText.substring(subVar.length()).toCharArray()[0]) || subLoc == allText.length() - subVar.length() && allText.substring(subLoc - 1).toCharArray()[0] != this.subPrefix || !Character.isDigit(allText.substring(subLoc + subVar.length()).toCharArray()[0]) && allText.substring(subLoc - 1).toCharArray()[0] != this.subPrefix) {
                ++this.numSubs;
            }
            subVar = String.valueOf(this.subPrefix) + new Integer(this.numSubs + 1).toString();
            subLoc = allText.indexOf(subVar);
        }
        return this.numSubs;
    }

    public String getLevelOneText() {
        return this.level1WS;
    }

    public String getLevelTwoText() {
        return this.level2WS;
    }

    public String getFullMessageID() {
        return String.valueOf(this.component) + this.subComponent + this.messageNumber + this.indicator;
    }

    public SystemMessage makeSubstitution(Object sub1) {
        this.level1WS = this.level1NS;
        this.level2WS = this.level2NS;
        this.makeSub(1, sub1);
        this.subs = new Object[1];
        this.subs[0] = sub1;
        return this;
    }

    public SystemMessage makeSubstitution(Object sub1, Object sub2) {
        this.level1WS = this.level1NS;
        this.level2WS = this.level2NS;
        this.makeSub(1, sub1);
        this.makeSub(2, sub2);
        this.subs = new Object[2];
        this.subs[0] = sub1;
        this.subs[1] = sub2;
        return this;
    }

    public SystemMessage makeSubstitution(Object sub1, Object sub2, Object sub3) {
        this.level1WS = this.level1NS;
        this.level2WS = this.level2NS;
        this.makeSub(1, sub1);
        this.makeSub(2, sub2);
        this.makeSub(3, sub3);
        this.subs = new Object[3];
        this.subs[0] = sub1;
        this.subs[1] = sub2;
        this.subs[2] = sub3;
        return this;
    }

    public SystemMessage makeSubstitution(Object sub1, Object sub2, Object sub3, Object sub4) {
        this.level1WS = this.level1NS;
        this.level2WS = this.level2NS;
        this.makeSub(1, sub1);
        this.makeSub(2, sub2);
        this.makeSub(3, sub3);
        this.makeSub(4, sub4);
        this.subs = new Object[4];
        this.subs[0] = sub1;
        this.subs[1] = sub2;
        this.subs[2] = sub3;
        this.subs[3] = sub4;
        return this;
    }

    public SystemMessage makeSubstitution(Object[] subsList) {
        this.level1WS = this.level1NS;
        this.level2WS = this.level2NS;
        if (subsList != null && subsList.length > 0) {
            int i = 0;
            while (i < subsList.length) {
                this.makeSub(i + 1, subsList[i]);
                ++i;
            }
        }
        this.subs = subsList;
        return this;
    }

    public Object[] getSubVariables() {
        return this.subs;
    }

    private void makeSub(int subNumber, Object sub) {
        if (sub == null) {
            return;
        }
        String subValue = this.getSubValue(sub);
        if (subNumber > this.getNumSubstitutionVariables()) {
            return;
        }
        String subVar = String.valueOf(this.subPrefix) + new Integer(subNumber).toString();
        int subLoc = -1;
        if (this.level1WS.equals(subVar)) {
            this.level1WS = subValue;
        } else {
            subLoc = this.level1WS.indexOf(subVar);
            while (subLoc >= 0) {
                if (subLoc == 0 && !Character.isDigit(this.level1WS.substring(subVar.length()).charAt(0)) || subLoc == this.level1WS.length() - subVar.length() && this.level1WS.substring(subLoc - 1).charAt(0) != this.subPrefix || !Character.isDigit(this.level1WS.substring(subLoc + subVar.length()).charAt(0)) && this.level1WS.substring(subLoc - 1).charAt(0) != this.subPrefix) {
                    this.level1WS = String.valueOf(this.level1WS.substring(0, subLoc)) + subValue + this.level1WS.substring(subLoc + subVar.length());
                }
                subLoc = this.level1WS.indexOf(subVar, subLoc + subValue.length());
            }
        }
        if (this.level2WS.equals(subVar)) {
            this.level2WS = subValue;
        } else {
            subLoc = this.level2WS.indexOf(subVar);
            while (subLoc >= 0) {
                if (subLoc == 0 && !Character.isDigit(this.level2WS.charAt(subVar.length())) || subLoc == this.level2WS.length() - subVar.length() && this.level2WS.substring(subLoc - 1).charAt(0) != this.subPrefix || !Character.isDigit(this.level2WS.substring(subLoc + subVar.length()).charAt(0)) && this.level2WS.substring(subLoc - 1).charAt(0) != this.subPrefix) {
                    this.level2WS = String.valueOf(this.level2WS.substring(0, subLoc)) + subValue + this.level2WS.substring(subLoc + subVar.length());
                }
                subLoc = this.level2WS.indexOf(subVar, subLoc + subValue.length());
            }
        }
    }

    public void setPrefixChar(char prefixChar) {
        this.subPrefix = prefixChar;
    }

    public static String sub(String target, String subOld, String subNew) {
        StringBuffer temp = new StringBuffer();
        int lastHit = 0;
        int newHit = 0;
        newHit = target.indexOf(subOld, lastHit);
        while (newHit != -1) {
            if (newHit >= 0) {
                temp.append(target.substring(lastHit, newHit));
            }
            temp.append(subNew);
            lastHit = newHit += subOld.length();
            newHit = target.indexOf(subOld, lastHit);
        }
        if (lastHit >= 0) {
            temp.append(target.substring(lastHit));
        }
        return temp.toString();
    }

    public String toString() {
        return String.valueOf(this.getFullMessageID()) + ": " + this.getLevelOneText();
    }

    public String getSubValue(Object sub) {
        if (sub == null) {
            return "";
        }
        if (sub instanceof Exception) {
            Exception exc = (Exception)sub;
            StringWriter excWriter = new StringWriter();
            exc.printStackTrace(new PrintWriter(excWriter));
            String msg = exc.toString();
            if (msg == null || exc instanceof ClassCastException) {
                msg = exc.getClass().getName();
            }
            return String.valueOf(msg) + "\n" + excWriter.toString();
        }
        return sub.toString();
    }
}

