/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.gqam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConnectorKind implements Enumerator
{
    SEQUENCE(0, "Sequence", "Sequence"),
    BRANCH(1, "Branch", "Branch"),
    MERGE(2, "Merge", "Merge"),
    FORK(3, "Fork", "Fork"),
    JOIN(4, "Join", "Join");

    public static final int SEQUENCE_VALUE = 0;
    public static final int BRANCH_VALUE = 1;
    public static final int MERGE_VALUE = 2;
    public static final int FORK_VALUE = 3;
    public static final int JOIN_VALUE = 4;
    private static final ConnectorKind[] VALUES_ARRAY;
    public static final List<ConnectorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConnectorKind[]{SEQUENCE, BRANCH, MERGE, FORK, JOIN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConnectorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectorKind get(int value) {
        switch (value) {
            case 0: {
                return SEQUENCE;
            }
            case 1: {
                return BRANCH;
            }
            case 2: {
                return MERGE;
            }
            case 3: {
                return FORK;
            }
            case 4: {
                return JOIN;
            }
        }
        return null;
    }

    private ConnectorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

