/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class PluginUtils {
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA-256";
    private static final String PLUGIN_JAR_PATH = "/gradle-plugin.jar";

    public static File getInitScript() {
        try {
            InputStream input = PluginUtils.class.getResourceAsStream(PLUGIN_JAR_PATH);
            byte[] pluginJarBytes = PluginUtils.readFully(input);
            byte[] pluginJarDigest = PluginUtils.getContentDigest(pluginJarBytes);
            String pluginJarName = PluginUtils.bytesToHex(pluginJarDigest) + ".jar";
            File pluginJarFile = new File(System.getProperty("java.io.tmpdir"), pluginJarName);
            if (PluginUtils.needReplaceContent(pluginJarFile, pluginJarDigest)) {
                Files.write(pluginJarFile.toPath(), pluginJarBytes, new OpenOption[0]);
            }
            String pluginJarUnixPath = pluginJarFile.getAbsolutePath().replace("\\", "/");
            String initScriptContent = "initscript {\n\tdependencies {\n\t\tclasspath files('" + pluginJarUnixPath + "')\n\t}\n}\n\nallprojects {\n\tapply plugin: com.microsoft.gradle.GradlePlugin\n}\n";
            byte[] initScriptBytes = initScriptContent.getBytes();
            byte[] initScriptDigest = PluginUtils.getContentDigest(initScriptBytes);
            String initScriptName = PluginUtils.bytesToHex(initScriptDigest) + ".gradle";
            File initScriptFile = new File(System.getProperty("java.io.tmpdir"), initScriptName);
            if (PluginUtils.needReplaceContent(initScriptFile, initScriptDigest)) {
                Files.write(initScriptFile.toPath(), initScriptBytes, new OpenOption[0]);
            }
            return initScriptFile;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte[] readFully(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    private static boolean needReplaceContent(File initScript, byte[] checksum) throws IOException, NoSuchAlgorithmException {
        if (!initScript.exists() || initScript.length() == 0L) {
            return true;
        }
        byte[] digest = PluginUtils.getContentDigest(Files.readAllBytes(initScript.toPath()));
        return !Arrays.equals(digest, checksum);
    }

    private static byte[] getContentDigest(byte[] contentBytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        md.update(contentBytes);
        return md.digest();
    }

    private static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }
}

