/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;

public class ECPoint {
    private final BigInteger x;
    private final BigInteger y;
    public static final ECPoint POINT_INFINITY = new ECPoint();

    private ECPoint() {
        this.x = null;
        this.y = null;
    }

    public ECPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null || bigInteger2 == null) {
            throw new NullPointerException("affine coordinate x or y is null");
        }
        this.x = bigInteger;
        this.y = bigInteger2;
    }

    public BigInteger getAffineX() {
        return this.x;
    }

    public BigInteger getAffineY() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this == POINT_INFINITY) {
            return false;
        }
        if (object instanceof ECPoint) {
            return this.x.equals(((ECPoint)object).x) && this.y.equals(((ECPoint)object).y);
        }
        return false;
    }

    public int hashCode() {
        if (this == POINT_INFINITY) {
            return 0;
        }
        return this.x.hashCode() << 5 + this.y.hashCode();
    }
}

