/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Dictionary;
import java.util.Enumeration;
import sun.misc.CacheEntry;
import sun.misc.CacheEnumerator;

public class Cache
extends Dictionary {
    private CacheEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    private void init(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new CacheEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public Cache(int n, float f) {
        this.init(n, f);
    }

    public Cache(int n) {
        this.init(n, 0.75f);
    }

    public Cache() {
        try {
            this.init(101, 0.75f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("panic");
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new CacheEnumerator(this.table, true);
    }

    public synchronized Enumeration elements() {
        return new CacheEnumerator(this.table, false);
    }

    public synchronized Object get(Object object) {
        CacheEntry[] cacheEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % cacheEntryArray.length;
        CacheEntry cacheEntry = cacheEntryArray[n2];
        while (cacheEntry != null) {
            if (cacheEntry.hash == n && cacheEntry.key.equals(object)) {
                return cacheEntry.check();
            }
            cacheEntry = cacheEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        CacheEntry[] cacheEntryArray = this.table;
        int n2 = n * 2 + 1;
        CacheEntry[] cacheEntryArray2 = new CacheEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = cacheEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            CacheEntry cacheEntry = cacheEntryArray[n3];
            while (cacheEntry != null) {
                CacheEntry cacheEntry2 = cacheEntry;
                cacheEntry = cacheEntry.next;
                if (cacheEntry2.check() != null) {
                    int n4 = (cacheEntry2.hash & Integer.MAX_VALUE) % n2;
                    cacheEntry2.next = cacheEntryArray2[n4];
                    cacheEntryArray2[n4] = cacheEntry2;
                    continue;
                }
                --this.count;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        CacheEntry[] cacheEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % cacheEntryArray.length;
        CacheEntry cacheEntry = null;
        CacheEntry cacheEntry2 = cacheEntryArray[n2];
        while (cacheEntry2 != null) {
            if (cacheEntry2.hash == n && cacheEntry2.key.equals(object)) {
                Object object3 = cacheEntry2.check();
                cacheEntry2.setThing(object2);
                return object3;
            }
            if (cacheEntry2.check() == null) {
                cacheEntry = cacheEntry2;
            }
            cacheEntry2 = cacheEntry2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            cacheEntry.next = cacheEntryArray[n2];
            cacheEntryArray[n2] = cacheEntry;
            ++this.count;
        }
        cacheEntry.hash = n;
        cacheEntry.key = object;
        cacheEntry.setThing(object2);
        return null;
    }

    public synchronized Object remove(Object object) {
        CacheEntry[] cacheEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % cacheEntryArray.length;
        CacheEntry cacheEntry = cacheEntryArray[n2];
        CacheEntry cacheEntry2 = null;
        while (cacheEntry != null) {
            if (cacheEntry.hash == n && cacheEntry.key.equals(object)) {
                if (cacheEntry2 != null) {
                    cacheEntry2.next = cacheEntry.next;
                } else {
                    cacheEntryArray[n2] = cacheEntry.next;
                }
                --this.count;
                return cacheEntry.check();
            }
            cacheEntry2 = cacheEntry;
            cacheEntry = cacheEntry.next;
        }
        return null;
    }
}

