/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.util.CheckClassAdapter;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorderPermission;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.handlers.EventHandler;
import jdk.jfr.internal.settings.PeriodSetting;
import jdk.jfr.internal.settings.StackTraceSetting;
import jdk.jfr.internal.settings.ThresholdSetting;

public final class Utils {
    private static final String INFINITY = "infinity";
    private static Boolean SAVE_GENERATED;
    public static final String EVENTS_PACKAGE_NAME = "jdk.jfr.events";
    public static final String INSTRUMENT_PACKAGE_NAME = "jdk.jfr.internal.instrument";
    public static final String HANDLERS_PACKAGE_NAME = "jdk.jfr.internal.handlers";
    public static final String REGISTER_EVENT = "registerEvent";
    public static final String ACCESS_FLIGHT_RECORDER = "accessFlightRecorder";
    private static final String LEGACY_EVENT_NAME_PREFIX = "com.oracle.jdk.";

    public static void checkAccessFlightRecorder() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new FlightRecorderPermission(ACCESS_FLIGHT_RECORDER));
        }
    }

    public static void checkRegisterPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new FlightRecorderPermission(REGISTER_EVENT));
        }
    }

    private static String formatDataAmount(String string, long l) {
        int n = (int)(Math.log(Math.abs(l)) / Math.log(1024.0));
        char c = "kMGTPE".charAt(n - 1);
        return String.format(string, (double)l / Math.pow(1024.0, n), Character.valueOf(c));
    }

    public static String formatBytesCompact(long l) {
        if (l < 1024L) {
            return String.valueOf(l);
        }
        return Utils.formatDataAmount("%.1f%cB", l);
    }

    public static String formatBits(long l) {
        if (l == 1L || l == -1L) {
            return l + " bit";
        }
        if (l < 1024L && l > -1024L) {
            return l + " bits";
        }
        return Utils.formatDataAmount("%.1f %cbit", l);
    }

    public static String formatBytes(long l) {
        if (l == 1L || l == -1L) {
            return l + " byte";
        }
        if (l < 1024L && l > -1024L) {
            return l + " bytes";
        }
        return Utils.formatDataAmount("%.1f %cB", l);
    }

    public static String formatBytesPerSecond(long l) {
        if (l < 1024L && l > -1024L) {
            return l + " byte/s";
        }
        return Utils.formatDataAmount("%.1f %cB/s", l);
    }

    public static String formatBitsPerSecond(long l) {
        if (l < 1024L && l > -1024L) {
            return l + " bps";
        }
        return Utils.formatDataAmount("%.1f %cbps", l);
    }

    public static String formatTimespan(Duration duration, String string) {
        if (duration == null) {
            return "0";
        }
        long l = duration.toNanos();
        TimespanUnit timespanUnit = TimespanUnit.NANOSECONDS;
        TimespanUnit[] timespanUnitArray = TimespanUnit.values();
        int n = timespanUnitArray.length;
        for (int i = 0; i < n; ++i) {
            TimespanUnit timespanUnit2;
            timespanUnit = timespanUnit2 = timespanUnitArray[i];
            long l2 = timespanUnit2.amount;
            if (timespanUnit == TimespanUnit.DAYS || l < l2 || l % l2 != 0L) break;
            l /= l2;
        }
        return String.format("%d%s%s", l, string, timespanUnit.text);
    }

    public static long parseTimespanWithInfinity(String string) {
        if (INFINITY.equals(string)) {
            return Long.MAX_VALUE;
        }
        return Utils.parseTimespan(string);
    }

    public static long parseTimespan(String string) {
        if (string.endsWith("ns")) {
            return Long.parseLong(string.substring(0, string.length() - 2).trim());
        }
        if (string.endsWith("us")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 2).trim()), TimeUnit.MICROSECONDS);
        }
        if (string.endsWith("ms")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 2).trim()), TimeUnit.MILLISECONDS);
        }
        if (string.endsWith("s")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (string.endsWith("m")) {
            return 60L * TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (string.endsWith("h")) {
            return 3600L * TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (string.endsWith("d")) {
            return 86400L * TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("'" + string + "' is not a valid timespan. Shoule be numeric value followed by a unit, i.e. 20 ms. Valid units are ns, us, s, m, h and d.");
        }
        throw new NumberFormatException("Timespan + '" + string + "' is missing unit. Valid units are ns, us, s, m, h and d.");
    }

    static List<Annotation> getAnnotations(Class<?> clazz) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Annotation annotation : clazz.getAnnotations()) {
            arrayList.addAll(Utils.getAnnotation(annotation));
        }
        return arrayList;
    }

    private static List<? extends Annotation> getAnnotation(Annotation annotation) {
        Class<? extends Annotation> clazz;
        Class<?> clazz2;
        Repeatable repeatable;
        Serializable serializable;
        Class<? extends Annotation> clazz3 = annotation.annotationType();
        Method method = Utils.getValueMethod(clazz3);
        if (method != null && ((Class)(serializable = method.getReturnType())).isArray() && (repeatable = (clazz2 = ((Class)serializable).getComponentType()).getAnnotation(Repeatable.class)) != null && clazz3 == (clazz = repeatable.value())) {
            return Utils.getAnnotationValues(annotation, method);
        }
        serializable = new ArrayList();
        serializable.add((Annotation)annotation);
        return serializable;
    }

    static boolean isAfter(RecordingState recordingState, RecordingState recordingState2) {
        return recordingState.ordinal() > recordingState2.ordinal();
    }

    static boolean isBefore(RecordingState recordingState, RecordingState recordingState2) {
        return recordingState.ordinal() < recordingState2.ordinal();
    }

    static boolean isState(RecordingState recordingState, RecordingState ... recordingStateArray) {
        for (RecordingState recordingState2 : recordingStateArray) {
            if (recordingState2 != recordingState) continue;
            return true;
        }
        return false;
    }

    private static List<Annotation> getAnnotationValues(Annotation annotation, Method method) {
        try {
            return Arrays.asList((Annotation[])method.invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return new ArrayList<Annotation>();
        }
    }

    private static Method getValueMethod(Class<?> clazz) {
        try {
            return clazz.getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void touch(Path path) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(path.toFile(), "rw");
        randomAccessFile.close();
    }

    public static Class<?> unboxType(Class<?> clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return clazz;
    }

    static long nanosToTicks(long l) {
        return (long)((double)l * JVM.getJVM().getTimeConversionFactor());
    }

    static synchronized EventHandler getHandler(Class<? extends Event> clazz) {
        Utils.ensureValidEventSubclass(clazz);
        try {
            Field field = clazz.getDeclaredField("eventHandler");
            SecuritySupport.setAccessible(field);
            return (EventHandler)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            throw new InternalError("Could not access event handler");
        }
    }

    static synchronized void setHandler(Class<? extends Event> clazz, EventHandler eventHandler) {
        Utils.ensureValidEventSubclass(clazz);
        try {
            Field field = clazz.getDeclaredField("eventHandler");
            SecuritySupport.setAccessible(field);
            field.set(null, eventHandler);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            throw new InternalError("Could not access event handler");
        }
    }

    public static Map<String, String> sanitizeNullFreeStringMap(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string == null) {
                throw new NullPointerException("Null key is not allowed in map");
            }
            String string2 = entry.getValue();
            if (string2 == null) {
                throw new NullPointerException("Null value is not allowed in map");
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public static <T> List<T> sanitizeNullFreeList(List<T> list, Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (T t : list) {
            if (t == null) {
                throw new NullPointerException("Null is not an allowed element in list");
            }
            if (t.getClass() != clazz) {
                throw new ClassCastException();
            }
            arrayList.add(t);
        }
        return arrayList;
    }

    static List<Field> getVisibleEventFields(Class<?> clazz) {
        Utils.ensureValidEventSubclass(clazz);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz2 = clazz; clazz2 != Event.class; clazz2 = clazz2.getSuperclass()) {
            for (Field field : clazz2.getDeclaredFields()) {
                if (clazz2 != clazz && Modifier.isPrivate(field.getModifiers())) continue;
                arrayList.add(field);
            }
        }
        return arrayList;
    }

    public static void ensureValidEventSubclass(Class<?> clazz) {
        if (Event.class.isAssignableFrom(clazz) && Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Abstract event classes are not allowed");
        }
        if (clazz == Event.class || !Event.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Must be a subclass to " + Event.class.getName());
        }
    }

    public static void writeGeneratedASM(String string, byte[] byArray) {
        if (SAVE_GENERATED == null) {
            SAVE_GENERATED = SecuritySupport.getBooleanProperty("jfr.save.generated.asm");
        }
        if (SAVE_GENERATED.booleanValue()) {
            try {
                try (Closeable closeable = new FileOutputStream(string + ".class");){
                    ((FileOutputStream)closeable).write(byArray);
                }
                closeable = new FileWriter(string + ".asm");
                var3_4 = null;
                try (PrintWriter printWriter = new PrintWriter((Writer)closeable);){
                    ClassReader classReader = new ClassReader(byArray);
                    CheckClassAdapter.verify(classReader, true, printWriter);
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (closeable != null) {
                        if (var3_4 != null) {
                            try {
                                ((OutputStreamWriter)closeable).close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStreamWriter)closeable).close();
                        }
                    }
                }
                Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.INFO, "Instrumented code saved to " + string + ".class and .asm");
            }
            catch (IOException iOException) {
                Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.INFO, "Could not save instrumented code, for " + string + ".class and .asm");
            }
        }
    }

    public static void ensureInitialized(Class<? extends Event> clazz) {
        SecuritySupport.ensureClassIsInitialized(clazz);
    }

    public static Object makePrimitiveArray(String string, List<Object> list) {
        int n = list.size();
        switch (string) {
            case "int": {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)list.get(i);
                }
                return nArray;
            }
            case "long": {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = (Long)list.get(i);
                }
                return lArray;
            }
            case "float": {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = ((Float)list.get(i)).floatValue();
                }
                return fArray;
            }
            case "double": {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = (Double)list.get(i);
                }
                return dArray;
            }
            case "short": {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (Short)list.get(i);
                }
                return sArray;
            }
            case "char": {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray[i] = ((Character)list.get(i)).charValue();
                }
                return cArray;
            }
            case "byte": {
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (Byte)list.get(i);
                }
                return byArray;
            }
            case "boolean": {
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = (Boolean)list.get(i);
                }
                return blArray;
            }
            case "java.lang.String": {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)list.get(i);
                }
                return stringArray;
            }
        }
        return null;
    }

    public static boolean isSettingVisible(Control control, boolean bl) {
        if (control instanceof ThresholdSetting) {
            return !bl;
        }
        if (control instanceof PeriodSetting) {
            return bl;
        }
        if (control instanceof StackTraceSetting) {
            return !bl;
        }
        return true;
    }

    public static boolean isSettingVisible(long l, boolean bl) {
        if (ThresholdSetting.isType(l)) {
            return !bl;
        }
        if (PeriodSetting.isType(l)) {
            return bl;
        }
        if (StackTraceSetting.isType(l)) {
            return !bl;
        }
        return true;
    }

    public static Type getValidType(Class<?> clazz, String string) {
        Objects.requireNonNull(clazz, "Null is not a valid type for value descriptor " + string);
        if (clazz.isArray() && (clazz = clazz.getComponentType()) != String.class && !clazz.isPrimitive()) {
            throw new IllegalArgumentException("Only arrays of primitives and Strings are allowed");
        }
        Type type = Type.getKnownType(clazz);
        if (type == null || type == Type.STACK_TRACE) {
            throw new IllegalArgumentException("Only primitive types, java.lang.Thread, java.lang.String and java.lang.Class are allowed for value descriptors. " + clazz.getName());
        }
        return type;
    }

    public static <T> List<T> smallUnmodifiable(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return Collections.unmodifiableList(list);
    }

    public static String upgradeLegacyJDKEvent(String string) {
        int n;
        if (string.length() <= LEGACY_EVENT_NAME_PREFIX.length()) {
            return string;
        }
        if (string.startsWith(LEGACY_EVENT_NAME_PREFIX) && (n = string.lastIndexOf(".")) == LEGACY_EVENT_NAME_PREFIX.length() - 1) {
            return "jdk." + string.substring(n + 1);
        }
        return string;
    }

    public static String makeFilename(Recording recording) {
        String string = JVM.getJVM().getPid();
        String string2 = Repository.REPO_DATE_FORMAT.format(LocalDateTime.now());
        String string3 = recording == null ? "" : "-id-" + Long.toString(recording.getId());
        return "hotspot-pid-" + string + string3 + "-" + string2 + ".jfr";
    }

    private static enum TimespanUnit {
        NANOSECONDS("ns", 1000L),
        MICROSECONDS("us", 1000L),
        MILLISECONDS("ms", 1000L),
        SECONDS("s", 60L),
        MINUTES("m", 60L),
        HOURS("h", 24L),
        DAYS("d", 7L);

        final String text;
        final long amount;

        private TimespanUnit(String string2, long l) {
            this.text = string2;
            this.amount = l;
        }
    }
}

