/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.security.SecureClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ByteCodeLoader
extends SecureClassLoader {
    private final Map<String, byte[]> classBytesMap;
    private final Map<String, Class<?>> cache;
    private static final Object lock = new Object();

    public ByteCodeLoader(Map<String, byte[]> classBytesMap, ClassLoader parent) {
        super(parent);
        this.classBytesMap = classBytesMap;
        this.cache = new ConcurrentHashMap();
    }

    public ByteCodeLoader(String className, byte[] byteCode) {
        this.classBytesMap = Map.of(className, byteCode);
        this.cache = new ConcurrentHashMap();
    }

    public ByteCodeLoader(String className, byte[] byteCode, ClassLoader parent) {
        this(Map.of(className, byteCode), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.classBytesMap.get(name) == null) {
            return super.loadClass(name);
        }
        Class<?> cls = this.cache.get(name);
        if (cls != null) {
            return cls;
        }
        Object object = lock;
        synchronized (object) {
            cls = this.cache.get(name);
            if (cls == null) {
                cls = this.findClass(name);
                this.cache.put(name, cls);
            }
        }
        return cls;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] byteCode = this.classBytesMap.get(name);
        if (byteCode == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, byteCode, 0, byteCode.length);
    }

    public static Class<?> load(String className, byte[] byteCode) throws ClassNotFoundException {
        return new ByteCodeLoader(className, byteCode).loadClass(className);
    }
}

