/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public final class SampleTree {
    protected JFrame frame;
    protected JTree tree;
    protected DefaultTreeModel treeModel;

    public SampleTree() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenuBar menuBar = this.constructMenuBar();
        JPanel panel = new JPanel(true);
        this.frame = new JFrame("SampleTree");
        this.frame.getContentPane().add("Center", panel);
        this.frame.setJMenuBar(menuBar);
        this.frame.setBackground(Color.lightGray);
        DefaultMutableTreeNode root = this.createNewNode("Root");
        this.treeModel = new SampleTreeModel(root);
        this.tree = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new SampleTreeCellRenderer());
        this.tree.setRowHeight(-1);
        JScrollPane sp = new JScrollPane();
        sp.setPreferredSize(new Dimension(300, 300));
        sp.getViewport().add(this.tree);
        panel.setLayout(new BorderLayout());
        panel.add("Center", sp);
        panel.add("South", this.constructOptionsPanel());
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private JPanel constructOptionsPanel() {
        JPanel retPanel = new JPanel(false);
        JPanel borderPane = new JPanel(false);
        borderPane.setLayout(new BorderLayout());
        retPanel.setLayout(new FlowLayout());
        JCheckBox aCheckbox = new JCheckBox("show top level handles");
        aCheckbox.setSelected(this.tree.getShowsRootHandles());
        aCheckbox.addChangeListener(new ShowHandlesChangeListener(this));
        retPanel.add(aCheckbox);
        aCheckbox = new JCheckBox("show root");
        aCheckbox.setSelected(this.tree.isRootVisible());
        aCheckbox.addChangeListener(new ShowRootChangeListener(this));
        retPanel.add(aCheckbox);
        aCheckbox = new JCheckBox("editable");
        aCheckbox.setSelected(this.tree.isEditable());
        aCheckbox.addChangeListener(new TreeEditableChangeListener(this));
        aCheckbox.setToolTipText("Triple click to edit");
        retPanel.add(aCheckbox);
        borderPane.add((Component)retPanel, "Center");
        ButtonGroup group = new ButtonGroup();
        JPanel buttonPane = new JPanel(false);
        buttonPane.setLayout(new FlowLayout());
        buttonPane.setBorder(new TitledBorder("Selection Mode"));
        JRadioButton button = new JRadioButton("Single");
        button.addActionListener(new AbstractAction(this){
            final /* synthetic */ SampleTree this$0;
            {
                SampleTree sampleTree = this$0;
                Objects.requireNonNull(sampleTree);
                this.this$0 = sampleTree;
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.tree.getSelectionModel().setSelectionMode(1);
            }
        });
        group.add(button);
        buttonPane.add(button);
        button = new JRadioButton("Contiguous");
        button.addActionListener(new AbstractAction(this){
            final /* synthetic */ SampleTree this$0;
            {
                SampleTree sampleTree = this$0;
                Objects.requireNonNull(sampleTree);
                this.this$0 = sampleTree;
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.tree.getSelectionModel().setSelectionMode(2);
            }
        });
        group.add(button);
        buttonPane.add(button);
        button = new JRadioButton("Discontiguous");
        button.addActionListener(new AbstractAction(this){
            final /* synthetic */ SampleTree this$0;
            {
                SampleTree sampleTree = this$0;
                Objects.requireNonNull(sampleTree);
                this.this$0 = sampleTree;
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.tree.getSelectionModel().setSelectionMode(4);
            }
        });
        button.setSelected(true);
        group.add(button);
        buttonPane.add(button);
        borderPane.add((Component)buttonPane, "South");
        return borderPane;
    }

    private JMenuBar constructMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.addActionListener(new ActionListener(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu = new JMenu("Tree");
        menuBar.add(menu);
        menuItem = menu.add(new JMenuItem("Add"));
        menuItem.addActionListener(new AddAction(this));
        menuItem = menu.add(new JMenuItem("Insert"));
        menuItem.addActionListener(new InsertAction(this));
        menuItem = menu.add(new JMenuItem("Reload"));
        menuItem.addActionListener(new ReloadAction(this));
        menuItem = menu.add(new JMenuItem("Remove"));
        menuItem.addActionListener(new RemoveAction(this));
        return menuBar;
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.tree.getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    protected TreePath[] getSelectedPaths() {
        return this.tree.getSelectionPaths();
    }

    protected DefaultMutableTreeNode createNewNode(String name) {
        return new DynamicTreeNode(new SampleData(null, Color.black, name));
    }

    public static void main(String[] args) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    new SampleTree();
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SampleTree.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(SampleTree.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    class ShowHandlesChangeListener
    implements ChangeListener {
        final /* synthetic */ SampleTree this$0;

        ShowHandlesChangeListener(SampleTree this$0) {
            SampleTree sampleTree = this$0;
            Objects.requireNonNull(sampleTree);
            this.this$0 = sampleTree;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.this$0.tree.setShowsRootHandles(((JCheckBox)e.getSource()).isSelected());
        }
    }

    class ShowRootChangeListener
    implements ChangeListener {
        final /* synthetic */ SampleTree this$0;

        ShowRootChangeListener(SampleTree this$0) {
            SampleTree sampleTree = this$0;
            Objects.requireNonNull(sampleTree);
            this.this$0 = sampleTree;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.this$0.tree.setRootVisible(((JCheckBox)e.getSource()).isSelected());
        }
    }

    class TreeEditableChangeListener
    implements ChangeListener {
        final /* synthetic */ SampleTree this$0;

        TreeEditableChangeListener(SampleTree this$0) {
            SampleTree sampleTree = this$0;
            Objects.requireNonNull(sampleTree);
            this.this$0 = sampleTree;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.this$0.tree.setEditable(((JCheckBox)e.getSource()).isSelected());
        }
    }

    class AddAction
    implements ActionListener {
        public int addCount;
        final /* synthetic */ SampleTree this$0;

        AddAction(SampleTree this$0) {
            SampleTree sampleTree = this$0;
            Objects.requireNonNull(sampleTree);
            this.this$0 = sampleTree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode parent;
            DefaultMutableTreeNode lastItem = this.this$0.getSelectedNode();
            if (lastItem != null) {
                parent = (DefaultMutableTreeNode)lastItem.getParent();
                if (parent == null) {
                    parent = (DefaultMutableTreeNode)this.this$0.treeModel.getRoot();
                    lastItem = null;
                }
            } else {
                parent = (DefaultMutableTreeNode)this.this$0.treeModel.getRoot();
            }
            if (parent == null) {
                this.this$0.treeModel.setRoot(this.this$0.createNewNode("Added " + Integer.toString(this.addCount++)));
            } else {
                int newIndex = lastItem == null ? this.this$0.treeModel.getChildCount(parent) : parent.getIndex(lastItem) + 1;
                this.this$0.treeModel.insertNodeInto(this.this$0.createNewNode("Added " + Integer.toString(this.addCount++)), parent, newIndex);
            }
        }
    }

    class InsertAction
    implements ActionListener {
        public int insertCount;
        final /* synthetic */ SampleTree this$0;

        InsertAction(SampleTree this$0) {
            SampleTree sampleTree = this$0;
            Objects.requireNonNull(sampleTree);
            this.this$0 = sampleTree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode parent;
            DefaultMutableTreeNode lastItem = this.this$0.getSelectedNode();
            if (lastItem != null) {
                parent = (DefaultMutableTreeNode)lastItem.getParent();
                if (parent == null) {
                    parent = (DefaultMutableTreeNode)this.this$0.treeModel.getRoot();
                    lastItem = null;
                }
            } else {
                parent = (DefaultMutableTreeNode)this.this$0.treeModel.getRoot();
            }
            if (parent == null) {
                this.this$0.treeModel.setRoot(this.this$0.createNewNode("Inserted " + Integer.toString(this.insertCount++)));
            } else {
                int newIndex = lastItem == null ? this.this$0.treeModel.getChildCount(parent) : parent.getIndex(lastItem);
                this.this$0.treeModel.insertNodeInto(this.this$0.createNewNode("Inserted " + Integer.toString(this.insertCount++)), parent, newIndex);
            }
        }
    }

    class ReloadAction
    implements ActionListener {
        final /* synthetic */ SampleTree this$0;

        ReloadAction(SampleTree this$0) {
            SampleTree sampleTree = this$0;
            Objects.requireNonNull(sampleTree);
            this.this$0 = sampleTree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode lastItem = this.this$0.getSelectedNode();
            if (lastItem != null) {
                this.this$0.treeModel.reload(lastItem);
            }
        }
    }

    class RemoveAction
    implements ActionListener {
        final /* synthetic */ SampleTree this$0;

        RemoveAction(SampleTree this$0) {
            SampleTree sampleTree = this$0;
            Objects.requireNonNull(sampleTree);
            this.this$0 = sampleTree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] selected = this.this$0.getSelectedPaths();
            if (selected != null && selected.length > 0) {
                TreePath shallowest;
                while ((shallowest = this.findShallowestPath(selected)) != null) {
                    this.removeSiblings(shallowest, selected);
                }
            }
        }

        private void removeSiblings(TreePath path, TreePath[] paths) {
            if (path.getPathCount() == 1) {
                for (int counter = paths.length - 1; counter >= 0; --counter) {
                    paths[counter] = null;
                }
                this.this$0.treeModel.setRoot(null);
            } else {
                TreePath parent = path.getParentPath();
                MutableTreeNode parentNode = (MutableTreeNode)parent.getLastPathComponent();
                ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
                for (int counter = paths.length - 1; counter >= 0; --counter) {
                    if (paths[counter] == null || !paths[counter].getParentPath().equals(parent)) continue;
                    toRemove.add(paths[counter]);
                    paths[counter] = null;
                }
                int rCount = toRemove.size();
                for (int counter = paths.length - 1; counter >= 0; --counter) {
                    if (paths[counter] == null) continue;
                    for (int rCounter = rCount - 1; rCounter >= 0; --rCounter) {
                        if (!((TreePath)toRemove.get(rCounter)).isDescendant(paths[counter])) continue;
                        paths[counter] = null;
                    }
                }
                if (rCount > 1) {
                    Collections.sort(toRemove, new PositionComparator(this));
                }
                int[] indices = new int[rCount];
                Object[] removedNodes = new Object[rCount];
                for (int counter = rCount - 1; counter >= 0; --counter) {
                    removedNodes[counter] = ((TreePath)toRemove.get(counter)).getLastPathComponent();
                    indices[counter] = this.this$0.treeModel.getIndexOfChild(parentNode, removedNodes[counter]);
                    parentNode.remove(indices[counter]);
                }
                this.this$0.treeModel.nodesWereRemoved(parentNode, indices, removedNodes);
            }
        }

        private TreePath findShallowestPath(TreePath[] paths) {
            int shallowest = -1;
            TreePath shallowestPath = null;
            for (int counter = paths.length - 1; counter >= 0; --counter) {
                if (paths[counter] == null) continue;
                if (shallowest != -1) {
                    if (paths[counter].getPathCount() >= shallowest) continue;
                    shallowest = paths[counter].getPathCount();
                    shallowestPath = paths[counter];
                    if (shallowest != 1) continue;
                    return shallowestPath;
                }
                shallowestPath = paths[counter];
                shallowest = paths[counter].getPathCount();
            }
            return shallowestPath;
        }

        private class PositionComparator
        implements Comparator<TreePath> {
            final /* synthetic */ RemoveAction this$1;

            private PositionComparator(RemoveAction removeAction) {
                RemoveAction removeAction2 = removeAction;
                Objects.requireNonNull(removeAction2);
                this.this$1 = removeAction2;
            }

            @Override
            public int compare(TreePath p1, TreePath p2) {
                int p1Index = this.this$1.this$0.treeModel.getIndexOfChild(p1.getParentPath().getLastPathComponent(), p1.getLastPathComponent());
                int p2Index = this.this$1.this$0.treeModel.getIndexOfChild(p2.getParentPath().getLastPathComponent(), p2.getLastPathComponent());
                return p1Index - p2Index;
            }
        }
    }
}

