/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.discovery.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.discovery.model.AbstractDiscoveryStrategy;
import org.eclipse.team.svn.core.discovery.model.DiscoveryCategory;
import org.eclipse.team.svn.core.discovery.model.DiscoveryConnector;
import org.eclipse.team.svn.core.discovery.model.FeatureFilter;
import org.eclipse.team.svn.core.discovery.util.WebUtil;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDiscovery {
    private List<DiscoveryConnector> connectors = Collections.emptyList();
    private List<DiscoveryCategory> categories = Collections.emptyList();
    private List<DiscoveryConnector> filteredConnectors = Collections.emptyList();
    private final List<AbstractDiscoveryStrategy> discoveryStrategies = new ArrayList<AbstractDiscoveryStrategy>();
    private Dictionary<String, Object> environment = new Hashtable<String, Object>();
    private boolean verifyUpdateSiteAvailability = false;
    private Map<String, Version> featureToVersion = null;

    public ConnectorDiscovery() {
        Properties props = System.getProperties();
        Enumeration iterator = ((Dictionary)props).keys();
        while (iterator.hasMoreElements()) {
            String key = (String)iterator.nextElement();
            this.environment.put(key, ((Dictionary)props).get(key));
        }
    }

    public List<AbstractDiscoveryStrategy> getDiscoveryStrategies() {
        return this.discoveryStrategies;
    }

    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (this.discoveryStrategies.isEmpty()) {
            throw new IllegalStateException();
        }
        this.connectors = new ArrayList<DiscoveryConnector>();
        this.filteredConnectors = new ArrayList<DiscoveryConnector>();
        this.categories = new ArrayList<DiscoveryCategory>();
        int totalTicks = 100000;
        int discoveryTicks = 90000;
        int filterTicks = 10000;
        monitor.beginTask(SVNMessages.ConnectorDiscovery_task_discovering_connectors, 100000);
        try {
            for (AbstractDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
                discoveryStrategy.setCategories(this.categories);
                discoveryStrategy.setConnectors(this.connectors);
                discoveryStrategy.performDiscovery((IProgressMonitor)new SubProgressMonitor(monitor, 90000 / this.discoveryStrategies.size()));
            }
            this.filterDescriptors();
            if (this.verifyUpdateSiteAvailability) {
                this.verifySiteAvailability((IProgressMonitor)new SubProgressMonitor(monitor, 10000));
            }
            this.connectCategoriesToDescriptors();
        }
        finally {
            monitor.done();
        }
    }

    public List<DiscoveryCategory> getCategories() {
        return this.categories;
    }

    public List<DiscoveryConnector> getConnectors() {
        return this.connectors;
    }

    public List<DiscoveryConnector> getFilteredConnectors() {
        return this.filteredConnectors;
    }

    public Dictionary getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Dictionary environment) {
        if (environment == null) {
            throw new IllegalArgumentException();
        }
        this.environment = environment;
    }

    public boolean isVerifyUpdateSiteAvailability() {
        return this.verifyUpdateSiteAvailability;
    }

    public void setVerifyUpdateSiteAvailability(boolean verifyUpdateSiteAvailability) {
        this.verifyUpdateSiteAvailability = verifyUpdateSiteAvailability;
    }

    public Map<String, Version> getFeatureToVersion() {
        return this.featureToVersion;
    }

    public void setFeatureToVersion(Map<String, Version> featureToVersion) {
        this.featureToVersion = featureToVersion;
    }

    private void connectCategoriesToDescriptors() {
        String errMessage;
        HashMap<String, DiscoveryCategory> idToCategory = new HashMap<String, DiscoveryCategory>();
        for (DiscoveryCategory category : this.categories) {
            DiscoveryCategory previous = idToCategory.put(category.getId(), category);
            if (previous == null) continue;
            errMessage = SVNMessages.format(SVNMessages.ConnectorDiscovery_duplicate_category_id, new Object[]{category.getId(), category.getSource().getId(), previous.getSource().getId()});
            LoggedOperation.reportError(this.getClass().getName(), new Exception(errMessage));
        }
        for (DiscoveryConnector connector : this.connectors) {
            DiscoveryCategory category = (DiscoveryCategory)idToCategory.get(connector.getCategoryId());
            if (category != null) {
                category.getConnectors().add(connector);
                connector.setCategory(category);
                continue;
            }
            errMessage = SVNMessages.format(SVNMessages.ConnectorDiscovery_bundle_references_unknown_category, new Object[]{connector.getCategoryId(), connector.getInstallableUnits(), connector.getSource().getId()});
            LoggedOperation.reportError(this.getClass().getName(), new Exception(errMessage));
        }
    }

    private void filterDescriptors() {
        block2: for (DiscoveryConnector connector : new ArrayList<DiscoveryConnector>(this.connectors)) {
            if (connector.getPlatformFilter() != null && connector.getPlatformFilter().trim().length() > 0) {
                boolean match = false;
                try {
                    Filter filter = FrameworkUtil.createFilter((String)connector.getPlatformFilter());
                    match = filter.match(this.environment);
                }
                catch (InvalidSyntaxException e) {
                    String errMessage = SVNMessages.format(SVNMessages.ConnectorDiscovery_illegal_filter_syntax, new Object[]{connector.getPlatformFilter(), connector.getInstallableUnits(), connector.getSource().getId()});
                    LoggedOperation.reportError(this.getClass().getName(), new Exception(errMessage, e));
                }
                if (!match) {
                    this.connectors.remove(connector);
                    this.filteredConnectors.add(connector);
                }
            }
            for (FeatureFilter featureFilter : connector.getFeatureFilter()) {
                VersionRange versionRange;
                if (this.featureToVersion == null) {
                    this.featureToVersion = this.computeFeatureToVersion();
                }
                boolean match = false;
                Version version = this.featureToVersion.get(featureFilter.getFeatureId());
                if (version != null && (versionRange = new VersionRange(featureFilter.getVersion())).isIncluded(version)) {
                    match = true;
                }
                if (match) continue;
                this.connectors.remove(connector);
                this.filteredConnectors.add(connector);
                continue block2;
            }
        }
    }

    private Map<String, Version> computeFeatureToVersion() {
        HashMap<String, Version> featureToVersion = new HashMap<String, Version>();
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = iBundleGroupProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup bundleGroup = iBundleGroupArray[n4];
                Bundle[] bundleArray = bundleGroup.getBundles();
                int n5 = bundleArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Bundle bundle = bundleArray[n6];
                    featureToVersion.put(bundle.getSymbolicName(), bundle.getVersion());
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return featureToVersion;
    }

    /*
     * Exception decompiling
     */
    public void verifySiteAvailability(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void dispose() {
        for (final AbstractDiscoveryStrategy strategy : this.discoveryStrategies) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    strategy.dispose();
                }

                public void handleException(Throwable exception) {
                    String errMessage = String.valueOf(SVNMessages.ConnectorDiscovery_exception_disposing) + strategy.getClass().getName();
                    LoggedOperation.reportError(this.getClass().getName(), new Exception(errMessage, exception));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerifyUpdateSiteJob
    implements Callable<VerifyUpdateSiteJob> {
        private final String url;
        private boolean ok = false;

        public VerifyUpdateSiteJob(String url) {
            this.url = url;
        }

        @Override
        public VerifyUpdateSiteJob call() throws Exception {
            URL baseUrl = new URL(this.url);
            URL[] locations = new URL[]{new URL(baseUrl, "content.jar"), new URL(baseUrl, "content.xml"), new URL(baseUrl, "site.xml")};
            this.ok = WebUtil.verifyAvailability(locations, true, (IProgressMonitor)new NullProgressMonitor());
            return this;
        }

        static /* synthetic */ String access$1(VerifyUpdateSiteJob verifyUpdateSiteJob) {
            return verifyUpdateSiteJob.url;
        }

        static /* synthetic */ boolean access$2(VerifyUpdateSiteJob verifyUpdateSiteJob) {
            return verifyUpdateSiteJob.ok;
        }
    }
}

