/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.connector;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;

public class SVNRevision {
    public static final SVNRevision HEAD = new SVNRevision(Kind.HEAD);
    public static final SVNRevision START = new SVNRevision(Kind.START);
    public static final SVNRevision COMMITTED = new SVNRevision(Kind.COMMITTED);
    public static final SVNRevision PREVIOUS = new SVNRevision(Kind.PREVIOUS);
    public static final SVNRevision BASE = new SVNRevision(Kind.BASE);
    public static final SVNRevision WORKING = new SVNRevision(Kind.WORKING);
    public static final int INVALID_REVISION_NUMBER = -1;
    public static final Number INVALID_REVISION = new Number(-1L);
    protected Kind revKind;

    public static SVNRevision fromKind(Kind kind) {
        switch (kind) {
            case BASE: {
                return BASE;
            }
            case WORKING: {
                return WORKING;
            }
            case HEAD: {
                return HEAD;
            }
            case PREVIOUS: {
                return PREVIOUS;
            }
            case START: {
                return START;
            }
            case COMMITTED: {
                return COMMITTED;
            }
            case DATE: {
                throw new IllegalArgumentException("Use fromDate() method instead");
            }
            case NUMBER: {
                throw new IllegalArgumentException("Use fromNumber() method instead");
            }
        }
        throw new IllegalArgumentException("Invalid revision kind: " + (Object)((Object)kind));
    }

    public static Number fromNumber(long revisionNumber) {
        if (revisionNumber < 0L) {
            throw new IllegalArgumentException("Negative revision numbers are not allowed: " + revisionNumber);
        }
        return new Number(revisionNumber);
    }

    public static Date fromDate(long revisionDate) {
        if (revisionDate == -1L) {
            throw new IllegalArgumentException("A date must be specified");
        }
        return new Date(revisionDate);
    }

    public static SVNRevision fromString(String revisionString) {
        revisionString = revisionString.toUpperCase();
        if (START.toString().equals(revisionString)) {
            return START;
        }
        if (BASE.toString().equals(revisionString)) {
            return BASE;
        }
        if (WORKING.toString().equals(revisionString)) {
            return WORKING;
        }
        if (COMMITTED.toString().equals(revisionString)) {
            return COMMITTED;
        }
        if (HEAD.toString().equals(revisionString)) {
            return HEAD;
        }
        if (PREVIOUS.toString().equals(revisionString)) {
            return PREVIOUS;
        }
        try {
            return SVNRevision.fromNumber(Long.parseLong(revisionString));
        }
        catch (NumberFormatException ex) {
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
            try {
                return SVNRevision.fromDate(dateTimeFormat.parse(revisionString).getTime());
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Invalid revision string: " + revisionString);
            }
        }
    }

    public Kind getKind() {
        return this.revKind;
    }

    public String toString() {
        return this.revKind.toString();
    }

    public int hashCode() {
        return this.revKind.id;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!this.getClass().equals(target.getClass())) {
            return false;
        }
        return ((SVNRevision)target).revKind == this.revKind;
    }

    protected SVNRevision(Kind kind) {
        this.revKind = kind;
    }

    public static class Date
    extends SVNRevision {
        protected long revDate;

        public long getDate() {
            return this.revDate;
        }

        public String toString() {
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
            return dateTimeFormat.format(new java.util.Date(this.revDate));
        }

        public int hashCode() {
            int result = 31;
            result += this.revKind.id;
            result = 31 * result + (int)this.revDate;
            result = 31 * result + (int)(this.revDate >> 32);
            return result;
        }

        public boolean equals(Object target) {
            return super.equals(target) && ((Date)target).revDate == this.revDate;
        }

        protected Date(long date) {
            super(Kind.DATE);
            this.revDate = date;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        START(0, "START"),
        NUMBER(1, ""),
        DATE(2, ""),
        COMMITTED(3, "COMMITTED"),
        PREVIOUS(4, "PREV"),
        BASE(5, "BASE"),
        WORKING(6, "WORKING"),
        HEAD(7, "HEAD");

        public final int id;
        private final String name;

        public String toString() {
            return this.name;
        }

        public static Kind fromId(int id) {
            Kind[] kindArray = Kind.values();
            int n = kindArray.length;
            int n2 = 0;
            while (n2 < n) {
                Kind kind = kindArray[n2];
                if (kind.id == id) {
                    return kind;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid revision kind: " + id);
        }

        private Kind(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class Number
    extends SVNRevision {
        protected long revNumber;

        public long getNumber() {
            return this.revNumber;
        }

        public String toString() {
            return String.valueOf(this.revNumber);
        }

        public int hashCode() {
            int result = 31;
            result += this.revKind.id;
            result = 31 * result + (int)this.revNumber;
            result = 31 * result + (int)(this.revNumber >> 32);
            return result;
        }

        public boolean equals(Object target) {
            return super.equals(target) && ((Number)target).revNumber == this.revNumber;
        }

        protected Number(long number) {
            super(Kind.NUMBER);
            this.revNumber = number;
        }
    }
}

