/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.resource;

import java.io.Serializable;
import org.eclipse.team.svn.core.resource.events.ISSHSettingsStateListener;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SSHSettings
implements Serializable {
    private static final long serialVersionUID = 300172856661110588L;
    public static final int SSH_PORT_DEFAULT = 22;
    protected int port = 22;
    protected boolean useKeyFile = false;
    protected String privateKeyPath = "";
    protected String passPhrase = "";
    protected boolean passPhraseSaved = false;
    private transient String passPhraseTemporary;
    private transient ISSHSettingsStateListener parentLocation;

    public SSHSettings() {
        this(null);
    }

    public SSHSettings(ISSHSettingsStateListener parentLocation) {
        this.parentLocation = parentLocation;
    }

    public String getPassPhrase() {
        return this.passPhraseSaved ? SVNUtility.base64Decode(this.passPhrase) : SVNUtility.base64Decode(this.passPhraseTemporary);
    }

    public void setPassPhrase(String passPhrase) {
        String oldValue = this.passPhraseSaved ? this.passPhrase : this.passPhraseTemporary;
        String string = oldValue = oldValue != null ? SVNUtility.base64Decode(oldValue) : oldValue;
        if (this.passPhraseSaved) {
            this.passPhrase = SVNUtility.base64Encode(passPhrase);
        } else {
            this.passPhraseTemporary = SVNUtility.base64Encode(passPhrase);
        }
        this.fireSSHChanged("sshPassPhrase", oldValue, passPhrase);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        int oldValue = this.port;
        this.port = port;
        this.fireSSHChanged("sshPort", oldValue, port);
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        String oldValue = this.privateKeyPath;
        this.privateKeyPath = privateKeyPath;
        this.fireSSHChanged("sshPrivateKeyPath", oldValue, privateKeyPath);
    }

    public boolean isUseKeyFile() {
        return this.useKeyFile;
    }

    public void setUseKeyFile(boolean useKeyFile) {
        boolean oldValue = this.useKeyFile;
        this.useKeyFile = useKeyFile;
        this.fireSSHChanged("sshUseKeyFile", oldValue, useKeyFile);
    }

    public boolean isPassPhraseSaved() {
        return this.passPhraseSaved;
    }

    public void setPassPhraseSaved(boolean passPhraseSaved) {
        if (this.passPhraseSaved == passPhraseSaved) {
            return;
        }
        boolean oldValue = this.passPhraseSaved;
        this.passPhraseSaved = passPhraseSaved;
        if (!passPhraseSaved) {
            this.passPhraseTemporary = this.passPhrase;
            this.passPhrase = null;
        } else {
            this.passPhrase = this.passPhraseTemporary;
        }
        this.fireSSHChanged("sshPassPhraseSaved", oldValue, passPhraseSaved);
    }

    protected void fireSSHChanged(String field, Object oldValue, Object newValue) {
        if (this.parentLocation != null) {
            this.parentLocation.sshChanged(null, field, oldValue, newValue);
        }
    }
}

