/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.management;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class CleanupOperation
extends AbstractFileOperation {
    public CleanupOperation(File[] files) {
        super("Operation_CleanupFile", SVNMessages.class, files);
    }

    public CleanupOperation(IFileProvider provider) {
        super("Operation_CleanupFile", SVNMessages.class, provider);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        SVNFileStorage storage = SVNFileStorage.instance();
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            IRepositoryResource remote = storage.asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            final String current = files[i].getAbsolutePath();
            ProgressMonitorUtility.setTaskInfo(monitor, this, current);
            this.writeToConsole(0, "svn cleanup \"" + FileUtility.normalizePath(current) + "\"\n");
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.cleanup(current, 0x78000000000L, new SVNProgressMonitor(CleanupOperation.this, monitor, null));
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

